<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateListingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('listings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('first_name');
            $table->string('last_name');
            $table->integer('firm_id')->unsigned();
            $table->text('phone');
            $table->text('fax');
            $table->text('url');
            $table->text('description');
            $table->text('email');
            $table->string('location');
            $table->integer('user_id')->unsigned();
            $table->integer('practice_area_id')->unsigned();
            $table->text('experience_years');
            $table->integer('jurisdiction_id')->unsigned();
            $table->text('languages');
            $table->text('address_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('listings');
    }
}
