@include('header')
@include('functions')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/homepage.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/map-css.css">
<!-- banner section start -->
<div class="banner-section-wapper">
    <div class="container w-1280">
        <div class="banner-main-wapper">
            <div class="banner-title">
                <h1><?php echo $page->extras['search_form_title']; ?></h1>
                <?php if($page->extras['section_1_short_description'] != ""){ ?>
                    <p class="short-content"><?php echo $page->extras['section_1_short_description']; ?></p>
                <?php } ?>
            </div>
            <div class="banner-title-h2">
                <?php if($page->extras['h2_after_short_description'] != ""){ ?>
                    <h2><?php echo $page->extras['h2_after_short_description']; ?></h2>
                <?php } ?>
            </div>
            @include('templates/top_filter')
        </div>
    </div>
</div>
<!-- banner section end -->              
<!-- Legal Guides section html -->

<section class="lg-section-wapper">
    <div class="lg-shape-top">
        <div class="container w-1280">

            <?php if($page->extras['sec_2_hide'] == 0){?>
                <div class="legal-card-wapper">
                    <div class="lg-sect-title">
                        <h2><span><?php echo $page->extras['sec_2_title']; ?></span></h2>
                    </div>
                    <div class="legal-guides-wapper">
                        <div class="legal-col">
                            <div class="legal-card">
                                <h3><a href="content-page.html">Injury Law</a></h3>
                                <p>Car Accidents, Medical Malpractice...</p>
                            </div>
                        </div>
                        <div class="legal-col">
                            <div class="legal-card">
                                <h3><a href="content-page.html">Injury Law</a></h3>
                                <p>Car Accidents, Medical Malpractice...</p>
                            </div>
                        </div>
                    </div>
                    <div class="legal-guides-btn-card">
                        <a href="#" id="legal-guides-btn">Load More</a>
                    </div>
                </div>
            <?php } ?>

            <div class="browse-by-states-section">
                <div class="browse-tab-section">
                    <div class="browse-box">
                        <div class="browse-bottom-border">
                            <ul class="browse-tabs">
                                <li class="browse-tab active" tab="t1"><a href="javascript:void(0)"> Browse by Practice Areas</a>
                                </li>
                                <li class="browse-tab" tab="t2"><a href="javascript:void(0)"> Browse by States</a></li>
                            </ul>
                        </div>
                        <div id="t1" class="content active">
                            <?php if(!empty($p_areas)){ ?>
                                <div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 row-cols-lg-5" >

                                    <?php foreach($p_areas as $p_a){ ?>
                                        <div class="col">
                                            <div class="browse-states browse-pa-list">
                                                <p>
                                                    <a href="{{ url('/') }}/lawyers/pa/{{ $p_a['slug'] }}" title="<?php echo $p_a['name']; ?>"><?php echo strWordCut($p_a['name'],25,$end='...'); ?></a>
                                                    <a class="m-pa-list-anchor" href="{{ url('/') }}/lawyers/{{ $p_a['slug'] }}" title="<?php echo $p_a['name']; ?>"><?php echo strWordCut($p_a['name'],15,$end='...'); ?></a>
                                                </p>
                                            </div>
                                        </div>
                                    <?php } ?>

                                </div>

                                <?php if(sizeof($p_areas) > 40){ ?>
                                    <div class="load-more">
                                        <a href="javascript:void(0)" class="loadMore_pa">Show More</a>
                                    </div>
                                <?php } ?>

                                <input type="hidden" id="l_parea_btn" value="0">
                                <input type="hidden" id="l_all_parea_link" value="{{ url('/') }}/lawyers/all-practice-areas">
                            <?php } ?>
                        </div>
                        <div id="t2" class="content ">
                            <?php if(!empty($states)){ ?>
                                <div class="row row-cols-2 row-cols-sm-2 row-cols-md-5" >
                                    <?php foreach($states as $state){ ?>
                                        <div class="col">
                                            <div class="browse-states">
                                                <p><a href="{{ url('/') }}/lawyers/loc/{{strtolower(str_replace(' ', '-', $state))}}" title="<?php echo $state; ?>"><?php echo strWordCut($state,25,$end='...'); ?></a></p>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                                

                                 <?php if(sizeof($states) > 40){ ?>
                                    <div class="load-more">
                                        <a href="#" class="loadMore_pa">Show More</a>
                                    </div>
                                <?php } ?>
                            <?php } ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Legal Guides section end -->

<!--  Find Personal Lawyer by State section html start -->
@include('templates/state_template')
<!--  Find Personal Lawyer by State section html end -->

<script src="{{ url('/') }}/js/map-js.js"></script>
<script src="{{ url('/') }}/js/homepage.js"></script>
@include('footer')
