<?php
namespace App\Http\Controllers;

use Backpack\PageManager\app\Models\Page;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\PracticeArea;
use App\Models\Listing;
use App\Models\listing_reviews;
use App\Models\Address;
use App\Models\State;
use App\Models\County;
use App\Models\PracticeAreaAndStateContent;
use App\Mail\LawyerContactEmail;

class lawyersController extends Controller
{

    // /lawyers
    public function lawyers($slug = "lawyers", $subs = null)
    {
        // META
        $page = Page::findBySlug($slug);
    
        // GET PRACTICE AREAS & STATES
        $same_list_ids = array();
        $p_areas = array();$list_parea = array();
        $all_states = array();$list_state = array();

        $practice_a = DB::select('SELECT * FROM `practice_areas` ORDER BY `name` ASC');
        $states = DB::select('SELECT * FROM `states` ORDER BY `name` ASC' );
        
        
        // $listing_ids = DB::table('listing_practice_area')
        // ->select('*')
        // ->join('listing_address', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        // ->get();


        $listing_ids = DB::table('listing_practice_area')
        ->select('*')
        ->join('listing_address', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        ->where('listing_practice_area.listing_id', '=', null)
        ->get();


        if(!empty($listing_ids)){
            foreach($listing_ids as $l_ids){
                array_push($same_list_ids, $l_ids->listing_id);
                array_push($list_parea, $l_ids->practice_area_id);
                array_push($list_state, $l_ids->state);
            }
        }
        $same_list_ids = array_filter(array_values(array_unique($same_list_ids)));
        $list_parea = array_filter(array_values(array_unique($list_parea)));
        $list_state = array_filter(array_values(array_unique($list_state)));

        if (!empty($practice_a) && !empty($list_parea)) {
            foreach ($practice_a as $p_a) {
                if(in_array($p_a->id, $list_parea)){
                    $p_areas[$p_a->id]['name'] = $p_a->name;
                    $p_areas[$p_a->id]['slug'] = $p_a->slug;
                }
            }
        }
        
        if (!empty($states) && !empty($list_state)) {
            foreach($states as $st){
                if(in_array($st->name, $list_state)){
                    array_push($all_states, $st->name);
                }
            }
        }

        $data["p_areas"] = $p_areas;
        $data["states"] = $all_states;
        // dd($page);
        return view('lawyers/lawyers_page', ['page' => $page, 'data' => $data])->withShortcodes();
    }

    // /lawyer/ id
    public function profile($slug)
    {
        $slug = explode('-', $slug);
        $slug = end($slug);

        $similar = array();

        $lawyer = Listing::with('firm')->with('education')->with('fee')->with('professional_experience')->with('jurisdiction')->with('education')->with('award')->with('language')->with('practiceAreas')->find($slug);

        if (!$lawyer) {
            return abort(404);
        }

        $reviews = DB::table('listing_reviews')->where('listing_id', $slug)->where('approved', 'yes')->get();
        $avg = 0;
        if ($reviews->count() > 0) {
            $avg = ceil($reviews->sum('rating') / $reviews->count());
        }

        if ($lawyer->jurisdiction && $lawyer->jurisdiction->isNotEmpty()) {
            if ($lawyer->jurisdiction->first()->since != "") {
                $lawyer->experience_years = date("Y") - $lawyer->jurisdiction->first()->since;
            }
        }

        // SET META
        $city = "";
        $p_area = "";
        $state = "";
        if ($lawyer->address && $lawyer->address->isNotEmpty()) {
            $address = $lawyer->address->first();
        }
        if ($lawyer->practiceAreas && $lawyer->practiceAreas->isNotEmpty()) {
            $p_area = $lawyer->practiceAreas->first();
        }
        if (!empty($address)) {
            $city = $address->city;
            $state = $address->state;
        }
        if (!empty($p_area)) {
            $p_area = $p_area->name;
        }

        $l_name = ($lawyer->prefix ? $lawyer->prefix . '.' : '') . ' ' . $lawyer->first_name . ' ' . ($lawyer->middle_name ? $lawyer->middle_name : '') . ' ' . $lawyer->last_name;

        $title = $l_name . ", Lawyer in " . $city . ", " . $state . " | Legal.com";
        $meta = array(
            "meta_title" => $title,
            "meta_description" => "Meet " . $l_name . ", an experienced attorney in " . $city . ", " . $state . ". Explore their background, services, and contact details here on Legal.com."
        );
        $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $lawyer->url_index];

        // Similar data
        if ($lawyer->featured != 1) {
            $similar = Listing::with('firm')->with('education')->with('fee')->with('professional_experience')->with('jurisdiction')->with('award')->with('language')->with('practiceAreas')->where('featured', 1)->get();
        }

        return view('lawyers/lawyers_profile_page', ['page' => $page, 'lawyer' => $lawyer, 'p_area' => $p_area, 'state' => $state, 'reviews' => $reviews, 'avg' => $avg, 'total_reviews' => $reviews->count(), 'similar' => $similar])->withShortcodes();
    }

    // ALL PRACTICE AREAS
    public function all_p_areas($slug = "all-practice-areas", $subs = null)
    {
        // META
        $page = Page::findBySlug($slug);

        // Practice Areas
        $all_pareas = array();
        $list_parea = array();

        $all_pa = DB::select('SELECT * FROM `practice_areas`');
        $list_pa = DB::select('SELECT * FROM `listing_practice_area`');
        if (!empty($list_pa)) {
            foreach ($list_pa as $lpa) {
                array_push($list_parea, $lpa->practice_area_id);
            }
            $list_parea = array_unique($list_parea);

        }

        if (!empty($all_pa)) {
            foreach ($all_pa as $apa) {
                if ($apa->parent_id == "" || $apa->parent_id == null) {
                    if (in_array($apa->id, $list_parea)) {
                        $all_pareas[$apa->id]['name'] = $apa->name;
                        $all_pareas[$apa->id]['slug'] = $apa->slug;
                    }
                }
            }

            foreach ($all_pa as $apa) {
                if ($apa->parent_id != "" || $apa->parent_id != null) {
                    if (isset($all_pareas[$apa->parent_id])) {
                        if (in_array($apa->id, $list_parea)) {
                            $all_pareas[$apa->parent_id][$apa->id]['name'] = $apa->name;
                            $all_pareas[$apa->parent_id][$apa->id]['slug'] = $apa->slug;
                        }
                    }
                }
            }
        }
        return view('lawyers/all_p_areas', ['page' => $page, 'all_pareas' => $all_pareas])->withShortcodes();
    }

    // /lawyers/pa/ [PracticeArea]
    public function lawyers_pa($pa)
    {
        // GET PRACTICE AREA DATA
        $practiceArea = PracticeArea::where('slug', $pa)->first();
        if (!$practiceArea) {
            return abort(404);
        }
        
        $p_area_data = DB::select('SELECT * FROM `practice_areas` WHERE `slug` = "' . $pa . '"');
        $p_area_faqs = DB::select('SELECT * FROM `practice_areas_faqs` WHERE `practice_area_id` =  "' . $practiceArea->id . '"');

        // SET META
        $title = "Best " . ucwords($practiceArea->name) . " Lawyers Near You | Legal.com";
        $meta = array(
            "meta_title" => $title,
            "meta_description" => "Connect with the top " . ucwords($practiceArea->name) . " attorneys near you. Explore our list on Legal.com to find experienced legal representation and achieve the best possible outcome for your case.",
        );
        $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $practiceArea->url_index];

        // STATES
        $list_parea = array();$list_state = array();
        $state = DB::table('listing_address')
        ->select('*')
        ->join('listing_practice_area', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        ->get();

        if ($state->count() > 0) {
            foreach ($state as $st) {
                array_push($list_parea, $st->practice_area_id);
                if($st->practice_area_id == $practiceArea->id){
                    array_push($list_state, trim($st->state));
                }
            }
        }
        $list_parea = array_filter(array_values(array_unique($list_parea)));
        $list_state = array_filter(array_values(array_unique($list_state)));
        sort($list_state);

        // RELETED PRACTICE AREAS
        $r_pareas = array();

        if ($practiceArea->parent_id == "" || $practiceArea->parent_id == null) {
            $sp_pareas = DB::select('SELECT * FROM `practice_areas` WHERE `parent_id` = "' . $practiceArea->id . '"');
        } else {
            $sp_pareas = DB::select('SELECT * FROM `practice_areas` WHERE `parent_id` = "' . $practiceArea->parent_id . '"');
        }

        if (!empty($sp_pareas)) {
            foreach ($sp_pareas as $spar) {
                if (in_array($spar->id, $list_parea) && $practiceArea->id != $spar->id) {
                    $r_pareas[$spar->id]['name'] = $spar->name;
                    $r_pareas[$spar->id]['slug'] = $spar->slug;
                }
            }
        }
        $pa_keys = array_column($r_pareas, 'name');
        array_multisort($pa_keys, SORT_ASC, $r_pareas);

        // GET LAWYERS
        $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
            $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
        })->orderby('featured', 'DESC')->paginate(10);

        return view('lawyers/lawyers_parea_page', ['page' => $page, 'p_area' => $pa, 'p_area_data' => $p_area_data, 'p_area_faqs' => $p_area_faqs, 'lawyers' => $lawyers, 'sp_pareas' => $r_pareas, 'states' => $list_state])->withShortcodes();
    }

    // /lawyers/loc/ [State]
    public function lawyers_s($state)
    {
        $state_slug = $state;
        $state = ucwords(str_replace("-", " ", $state));

        // GET STATE DATA
        $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');
        if (empty($state_data)) {
            return abort(404);
        }

        $state_faq = DB::select('SELECT * FROM `states_faqs` WHERE `state_id` = "' . $state_data[0]->id . '"');

        // GET PRACTICE AREAS
        $all_pareas = array();
        $list_cities = array();
        $list_counties = array();
        $pareas = DB::table('listing_practice_area')
        ->select('*')
        ->join('listing_address', 'listing_practice_area.listing_id', '=', 'listing_address.listing_id')
        ->where('listing_address.state', $state)
        ->orderBy('listing_practice_area.listing_id', 'ASC')
        ->get();

        if ($pareas->count() > 0) {
            foreach ($pareas as $parea) {
                $p_data = DB::select('SELECT * FROM `practice_areas` WHERE id="' . $parea->practice_area_id . '"');

                if (!empty($p_data) && !isset($all_pareas[$p_data[0]->id])) {
                    $all_pareas[$p_data[0]->id]['name'] = $p_data[0]->name;
                    $all_pareas[$p_data[0]->id]['slug'] = $p_data[0]->slug;
                }
                array_push($list_cities, $parea->city);
                array_push($list_counties, $parea->county);
            }
            $list_cities = array_filter(array_values(array_unique($list_cities)));
            $list_counties = array_filter(array_values(array_unique($list_counties)));
            sort($list_cities);
            sort($list_counties);
        }
        $keys = array_column($all_pareas, 'name');
        array_multisort($keys, SORT_ASC, $all_pareas);
        $data["p_areas"] = $all_pareas;


        // GET STATE CITIES & COUNTIES
        $cities = DB::select('SELECT * FROM `counties` WHERE `type` = "City" AND `state_name` LIKE "%' . $state . '%" ORDER BY name ASC');
        if (!empty($cities)) {
            foreach ($cities as $ck => $cval) {
                if (!in_array($cval->name, $list_cities)) {
                    unset($cities[$ck]);
                }
            }
        }

        $counties = DB::select('SELECT * FROM `counties` WHERE `type` = "County" AND `state_name` LIKE "%' . $state . '%" ORDER BY name ASC');
        if (!empty($counties)) {
            foreach ($counties as $ck => $cval) {
                if (!in_array($cval->name, $list_counties)) {
                    unset($counties[$ck]);
                }
            }
        }

        // SET META
        $title = "Best Lawyers in $state | Legal.com";
        $m_des = "Connect with the top attorneys in $state. Explore our list on Legal.com to find experienced legal representation in $state and achieve the best possible outcome for your case.";
        $meta = array("meta_title" => $title, "meta_description" => $m_des);
        $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $state_data[0]->url_index];

        // GET LAWYERS
        $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('address', function ($query) use ($state) {
            $query->where('state', $state);
        })->orderby('featured', 'DESC')->paginate(10);

        return view('lawyers/lawyers_state_page', ['page' => $page, 'state' => $state_slug, 'state_data' => $state_data, 'faqs' => $state_faq, 
            'cities' => $cities, 'counties' => $counties, 'lawyers' => $lawyers, 'data' => $data])->withShortcodes();
    }

    // url = /lawyers/loc/ [State] / [City | County]
    public function lawyers_s_and_c($state, $city)
    {   
        $city_slug = $city;

        if (strpos($city_slug, '.') !== false) {
            return redirect(url('/') . '/lawyers/loc/' . $state .'/'.str_replace(".", "", $city_slug), 301);
        }

        $state = ucwords(str_replace("-", " ", $state));
        $city = ucwords(str_replace("-", " ", str_replace("-county", "", $city )));

        $dot_arr = array("1356" => "West St. Paul", "2488" => "Village St. George", "4866" => "Ste. Marie", "4867" => "Ste. Genevieve County", "4868" => "Ste. Genevieve", "5001" => "St. Xavier", "5002" => "St. Vincent College", "5003" => "St. Vincent", "5004" => "St. Thomas", "5005" => "St. Thomas", "5006" => "St. Tammany  County", "5007" => "St. Stephens", "5008" => "St. Stephens", "5009" => "St. Stephen", "5010" => "St. Stephen", "5011" => "St. Simons", "5012" => "St. Rose", "5013" => "St. Rose", "5014" => "St. Rosa", "5015" => "St. Robert", "5016" => "St. Regis Park", "5017" => "St. Regis Falls", "5018" => "St. Regis", "5019" => "St. Pierre", "5020" => "St. Petersburg", "5021" => "St. Petersburg", "5022" => "St. Peters", "5023" => "St. Peter", "5024" => "St. Peter", "5025" => "St. Peter", "5026" => "St. Pete Beach", "5027" => "St. Pauls", "5028" => "St. Paul Park", "5029" => "St. Paul", "5030" => "St. Paul", "5031" => "St. Paul", "5032" => "St. Paul", "5033" => "St. Paul", "5034" => "St. Paul", "5035" => "St. Paul", "5036" => "St. Paul", "5037" => "St. Paul", "5038" => "St. Paul", "5039" => "St. Paul", "5040" => "St. Paris", "5041" => "St. Onge", "5042" => "St. Olaf", "5043" => "St. Nazianz", "5044" => "St. Michaels", "5045" => "St. Michaels", "5046" => "St. Michael", "5047" => "St. Michael", "5048" => "St. Michael", "5049" => "St. Meinrad", "5050" => "St. Maurice", "5051" => "St. Matthews", "5052" => "St. Matthews", "5053" => "St. Marys Point", "5054" => "St. Marys", "5055" => "St. Marys", "5056" => "St. Marys", "5057" => "St. Marys", "5058" => "St. Marys", "5059" => "St. Marys", "5060" => "St. Mary's  County", "5061" => "St. Mary's", "5062" => "St. Mary's", "5063" => "St. Mary of the Woods", "5064" => "St. Mary County", "5065" => "St. Mary", "5066" => "St. Mary", "5067" => "St. Martinville", "5068" => "St. Martins", "5069" => "St. Martin County", "5070" => "St. Martin", "5071" => "St. Martin", "5072" => "St. Martin", "5073" => "St. Marks", "5074" => "St. Maries", "5075" => "St. Marie", "5076" => "St. Lucie Village", "5077" => "St. Lucie County", "5078" => "St. Lucas", "5079" => "St. Louisville", "5080" => "St. Louis Park", "5081" => "St. Louis County", "5082" => "St. Louis County", "5083" => "St. Louis County", "5084" => "St. Louis", "5085" => "St. Louis", "5086" => "St. Louis", "5087" => "St. Libory", "5088" => "St. Libory", "5089" => "St. Leonard", "5090" => "St. Leon", "5091" => "St. Leo", "5092" => "St. Leo", "5093" => "St. Lawrence County", "5094" => "St. Lawrence", "5095" => "St. Lawrence", "5096" => "St. Landry County", "5097" => "St. Joseph County", "5098" => "St. Joseph County", "5099" => "St. Joseph", "5100" => "St. Joseph", "5101" => "St. Joseph", "5102" => "St. Joseph", "5103" => "St. Joseph", "5104" => "St. Joseph", "5105" => "St. Joseph", "5106" => "St. Joseph", "5107" => "St. Johns County", "5108" => "St. Johns", "5109" => "St. Johns", "5110" => "St. Johns", "5111" => "St. Johns", "5112" => "St. John the Baptist County", "5113" => "St. John", "5114" => "St. John", "5115" => "St. John", "5116" => "St. John", "5117" => "St. John", "5118" => "St. Joe", "5119" => "St. Joe", "5120" => "St. Jo", "5121" => "St. James City", "5122" => "St. James County", "5123" => "St. James", "5124" => "St. James", "5125" => "St. James", "5126" => "St. James", "5127" => "St. James", "5128" => "St. James", "5129" => "St. James", "5130" => "St. Jacob", "5131" => "St. Ignatius", "5132" => "St. Ignace", "5133" => "St. Hilaire", "5134" => "St. Henry", "5135" => "St. Helens", "5136" => "St. Helena County", "5137" => "St. Helena", "5138" => "St. Helena", "5139" => "St. Helena", "5140" => "St. Helen", "5141" => "St. Hedwig", "5142" => "St. Georges", "5143" => "St. George Island", "5144" => "St. George Island", "5145" => "St. George", "5146" => "St. George", "5147" => "St. George", "5148" => "St. George", "5149" => "St. George", "5150" => "St. George", "5151" => "St. Gabriel", "5152" => "St. Francois County", "5153" => "St. Francisville", "5154" => "St. Francisville", "5155" => "St. Francisville", "5156" => "St. Francis County", "5157" => "St. Francis", "5158" => "St. Francis", "5159" => "St. Francis", "5160" => "St. Francis", "5161" => "St. Francis", "5162" => "St. Florian", "5163" => "St. Elmo", "5164" => "St. Elizabeth", "5165" => "St. Edward", "5166" => "St. Donatus", "5167" => "St. David", "5168" => "St. David", "5169" => "St. Croix Falls", "5170" => "St. Croix County", "5171" => "St. Cloud", "5172" => "St. Cloud", "5173" => "St. Cloud", "5174" => "St. Cloud", "5175" => "St. Clement", "5176" => "St. Clairsville", "5177" => "St. Clairsville", "5178" => "St. Clair Shores", "5179" => "St. Clair County", "5180" => "St. Clair County", "5181" => "St. Clair County", "5182" => "St. Clair", "5183" => "St. Clair", "5184" => "St. Clair", "5185" => "St. Clair", "5186" => "St. Clair", "5187" => "St. Charles County", "5188" => "St. Charles County", "5189" => "St. Charles", "5190" => "St. Charles", "5191" => "St. Charles", "5192" => "St. Charles", "5193" => "St. Charles", "5194" => "St. Charles", "5195" => "St. Charles", "5196" => "St. Charles", "5197" => "St. Charles", "5198" => "St. Charles", "5199" => "St. Bonifacius", "5200" => "St. Bonaventure", "5201" => "St. Bernice", "5202" => "St. Bernard", "5203" => "St. Bernard", "5204" => "St. Benedict", "5205" => "St. Augustine South", "5206" => "St. Augustine Shores", "5207" => "St. Augustine Beach", "5208" => "St. Augustine", "5209" => "St. Augustine", "5210" => "St. Augusta", "5211" => "St. Anthony", "5212" => "St. Anthony", "5213" => "St. Anthony", "5214" => "St. Ansgar", "5215" => "St. Anne", "5216" => "St. Ann Highlands", "5217" => "St. Ann", "5218" => "St. Andrews", "5219" => "St. Albans", "5220" => "St. Albans", "5524" => "South St. Paul", "6860" => "Sault Ste. Marie", "9420" => "Port St. Lucie", "9421" => "Port St. John", "9422" => "Port St. Joe", "11989" => "North St. Paul", "15376" => "Marine on St. Croix", "16006" => "Luis M. Cintrón", "17598" => "Lake St. Louis", "17599" => "Lake St. Croix Beach", "18797" => "K. I. Sawyer", "19284" => "J.F. Villareal", "21482" => "H. Rivera Colón", "21483" => "H. Cuellar Estates", "22445" => "Glen St. Mary", "23008" => "G. L. García", "25285" => "East St. Louis", "25534" => "E. Lopez", "29469" => "Cape St. Claire", "32160" => "Bay St. Louis", );

        $nw_arr = array();
        if (!empty($dot_arr)) {
            $nw_i = 0;
            foreach ($dot_arr as $ky => $da) {
                $da_new = str_replace(".", "-", $da);
                $da_new = str_replace(" ", "-", $da_new);
                $da_new = str_replace("--", "-", $da_new);
                $nw_arr[$nw_i]['slug'] = strtolower($da_new);
                $nw_arr[$nw_i]['name'] = $da;
                $nw_i++;
            }
        }

        if(!empty($nw_arr)){
            $key = array_search($city_slug, array_column($nw_arr, 'slug'));

            if($key != ""){
                $city = $nw_arr[$key]['name'];
            }
        }

        // GET CITY|COUNTY DATA
        if (strpos($city_slug, '-county') !== false) {
            $city_data = DB::select('SELECT * FROM `counties` WHERE `state_name` LIKE "%' . $state . '%" AND `name` = "' . $city . '" AND `type`="County"');
        }else{
            $city_data = DB::select('SELECT * FROM `counties` WHERE `state_name` LIKE "%' . $state . '%" AND `name` = "' . $city . '" AND `type`="City"');
        }

        if (empty($city_data)) {
            return abort(404);
        }

        $city_faq = DB::select('SELECT * FROM `counties_faqs` WHERE `county_id` = "' . $city_data[0]->id . '"');

        // GET PRACTICE AREAS
        $all_pareas = array();
        $list_parea = array();

        $list_pa = DB::select('SELECT * FROM `listing_practice_area`');

        if (!empty($list_pa)) {
            foreach ($list_pa as $lpa) {
                array_push($list_parea, $lpa->practice_area_id);
            }
            $list_parea = array_unique($list_parea);
        }

        if ($city_data[0]->type == "City") {
            $pareas = DB::select('select * from `listing_practice_area` inner join `listing_address` on
               `listing_address`.`listing_id` = `listing_practice_area`.`listing_id` 
               where `listing_address`.`city` = "' . $city_data[0]->name . '" and `listing_address`.`state` = "' . $city_data[0]->state_name . '"');
        } else {
            $pareas = DB::select('select * from `listing_practice_area` inner join `listing_address` on
               `listing_address`.`listing_id` = `listing_practice_area`.`listing_id` 
               where `listing_address`.`county` = "' . $city_data[0]->name . '" and `listing_address`.`state` = "' . $city_data[0]->state_name . '"');
        }

        if (!empty($pareas)) {
            foreach ($pareas as $p_a) {
                if (in_array($p_a->practice_area_id, $list_parea)) {
                    $p_data = DB::select('SELECT * FROM `practice_areas` WHERE id="' . $p_a->practice_area_id . '"');

                    if (!empty($p_data) && !isset($all_pareas[$p_data[0]->id])) {
                        $all_pareas[$p_data[0]->id]['name'] = $p_data[0]->name;
                        $all_pareas[$p_data[0]->id]['slug'] = $p_data[0]->slug;
                    }
                }
            }
        }
        $keys = array_column($all_pareas, 'name');
        array_multisort($keys, SORT_ASC, $all_pareas);
        $data["p_areas"] = $all_pareas;

        // SET META
        $title = "Best Lawyers in $city, $state | Legal.com";
        $m_des = "Explore top-rated defense attorneys in $city, $state. Local expertise, ready to assist with your legal needs on Legal.com.";
        $meta = array("meta_title" => $title, "meta_description" => $m_des);
        $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $city_data[0]->url_index];

        if($city_data[0]->type == "County"){
            $city = $city.'-county';
        }

        return view('lawyers/lawyers_state_city_page', ['page' => $page, 'state' => $state, 'city' => $city, 'city_data' => $city_data, 'faqs' => $city_faq, 'data' => $data])->withShortcodes();
    }

    // /lawyers/pa/ [PracticeArea] / [State]
    public function lawyers_pa_and_s($p_area, $state)
    {
        $p_slug = $p_area;
        $s_slug = $state;
        $p_area = ucwords(str_replace("-", " ", $p_area));
        $state = ucwords(str_replace("-", " ", $state));

        // GET PRACTICE AREAS
        $p_areas = array();
        $list_parea = array();

        $list_pa = DB::select('SELECT * FROM `listing_practice_area`');
        $practice_a = DB::select('SELECT * FROM `practice_areas` ORDER BY `name` ASC');

        if (!empty($list_pa)) {
            foreach ($list_pa as $lpa) {
                array_push($list_parea, $lpa->practice_area_id);
            }
            $list_parea = array_unique($list_parea);
        }

        if (!empty($practice_a) && !empty($list_pa)) {
            foreach ($practice_a as $p_a) {
                if (in_array($p_a->id, $list_parea)) {
                    $p_areas[$p_a->id]['name'] = $p_a->name;
                    $p_areas[$p_a->id]['slug'] = $p_a->slug;
                }
            }
        }

        $data["p_areas"] = $p_areas;

        $practiceArea = PracticeArea::where('slug', $p_slug)->first();
        $statedt = State::where('name', $state)->first();
        
        if (empty($practiceArea)) {
            return abort(404);
        }

        // SET META
        $title = "Best $practiceArea->name Lawyers in $state | Legal.com";
        $m_des = "Connect with the top $practiceArea->name attorneys in $state. Explore our list on Legal.com to find experienced legal representation in $state and achieve the best possible outcome for your case.";

        $meta = array(
            "meta_title" => $title,
            "meta_description" => $m_des
        );
        $page = (object) ['extras' => $meta, "title" => $title];

        // GET CONTENT
        $content = array();
        $cdata = array();

        if ($practiceArea->id != "" && !empty($statedt) && $statedt->id != "") {
            $content = DB::table('practice_area_state_content')
            ->where('practiceArea', $practiceArea->id)
            ->where('state', $statedt->id)->first();

            if (isset($content->extras) && !empty($content->extras)) {

                $cdata = json_decode($content->extras);

                if (!empty($cdata)) {
                    if ($cdata->meta_title != "") {
                        $title = $cdata->meta_title;
                    }
                    if ($cdata->meta_description != "") {
                        $m_des = $cdata->meta_description;
                    }

                    $meta = array(
                        "meta_title" => $title,
                        "meta_description" => $m_des
                    );
                    $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $content->url_index];
                }
            }
        }

        // GET LAWYERS
        $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
            $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
        })->whereHas('address', function ($query) use ($state) {
            $query->where('state', $state);
        })->orderby('featured', 'DESC')->paginate(6);


        return view('lawyers/lawyers_parea_state_page', ['page' => $page, 'p_area' => $p_area, 'state' => $state, 'city' => '', 'lawyers' => $lawyers,
         'data' => $data, 'content' => $content, 'cdata' => $cdata, 'p_area_data' => $practiceArea])->withShortcodes();
    }

    // /lawyers/ [PracticeArea] / [State] / [city]
    public function lawyers_pa_and_s_and_c($p_area, $state, $city)
    {   
        $city_slug = $city;
        $state = ucwords(str_replace("-", " ", $state));
        $city = ucwords(str_replace("-", " ", str_replace("-county", "", $city )));

        if (strpos($city_slug, '.') !== false) {
            return redirect(url('/') . '/lawyers/pa/' . $state .'/'.str_replace(".", "", $city_slug), 301);
        }

        $dot_arr = array("1356" => "West St. Paul", "2488" => "Village St. George", "4866" => "Ste. Marie", "4867" => "Ste. Genevieve County", "4868" => "Ste. Genevieve", "5001" => "St. Xavier", "5002" => "St. Vincent College", "5003" => "St. Vincent", "5004" => "St. Thomas", "5005" => "St. Thomas", "5006" => "St. Tammany  County", "5007" => "St. Stephens", "5008" => "St. Stephens", "5009" => "St. Stephen", "5010" => "St. Stephen", "5011" => "St. Simons", "5012" => "St. Rose", "5013" => "St. Rose", "5014" => "St. Rosa", "5015" => "St. Robert", "5016" => "St. Regis Park", "5017" => "St. Regis Falls", "5018" => "St. Regis", "5019" => "St. Pierre", "5020" => "St. Petersburg", "5021" => "St. Petersburg", "5022" => "St. Peters", "5023" => "St. Peter", "5024" => "St. Peter", "5025" => "St. Peter", "5026" => "St. Pete Beach", "5027" => "St. Pauls", "5028" => "St. Paul Park", "5029" => "St. Paul", "5030" => "St. Paul", "5031" => "St. Paul", "5032" => "St. Paul", "5033" => "St. Paul", "5034" => "St. Paul", "5035" => "St. Paul", "5036" => "St. Paul", "5037" => "St. Paul", "5038" => "St. Paul", "5039" => "St. Paul", "5040" => "St. Paris", "5041" => "St. Onge", "5042" => "St. Olaf", "5043" => "St. Nazianz", "5044" => "St. Michaels", "5045" => "St. Michaels", "5046" => "St. Michael", "5047" => "St. Michael", "5048" => "St. Michael", "5049" => "St. Meinrad", "5050" => "St. Maurice", "5051" => "St. Matthews", "5052" => "St. Matthews", "5053" => "St. Marys Point", "5054" => "St. Marys", "5055" => "St. Marys", "5056" => "St. Marys", "5057" => "St. Marys", "5058" => "St. Marys", "5059" => "St. Marys", "5060" => "St. Mary's  County", "5061" => "St. Mary's", "5062" => "St. Mary's", "5063" => "St. Mary of the Woods", "5064" => "St. Mary County", "5065" => "St. Mary", "5066" => "St. Mary", "5067" => "St. Martinville", "5068" => "St. Martins", "5069" => "St. Martin County", "5070" => "St. Martin", "5071" => "St. Martin", "5072" => "St. Martin", "5073" => "St. Marks", "5074" => "St. Maries", "5075" => "St. Marie", "5076" => "St. Lucie Village", "5077" => "St. Lucie County", "5078" => "St. Lucas", "5079" => "St. Louisville", "5080" => "St. Louis Park", "5081" => "St. Louis County", "5082" => "St. Louis County", "5083" => "St. Louis County", "5084" => "St. Louis", "5085" => "St. Louis", "5086" => "St. Louis", "5087" => "St. Libory", "5088" => "St. Libory", "5089" => "St. Leonard", "5090" => "St. Leon", "5091" => "St. Leo", "5092" => "St. Leo", "5093" => "St. Lawrence County", "5094" => "St. Lawrence", "5095" => "St. Lawrence", "5096" => "St. Landry County", "5097" => "St. Joseph County", "5098" => "St. Joseph County", "5099" => "St. Joseph", "5100" => "St. Joseph", "5101" => "St. Joseph", "5102" => "St. Joseph", "5103" => "St. Joseph", "5104" => "St. Joseph", "5105" => "St. Joseph", "5106" => "St. Joseph", "5107" => "St. Johns County", "5108" => "St. Johns", "5109" => "St. Johns", "5110" => "St. Johns", "5111" => "St. Johns", "5112" => "St. John the Baptist County", "5113" => "St. John", "5114" => "St. John", "5115" => "St. John", "5116" => "St. John", "5117" => "St. John", "5118" => "St. Joe", "5119" => "St. Joe", "5120" => "St. Jo", "5121" => "St. James City", "5122" => "St. James County", "5123" => "St. James", "5124" => "St. James", "5125" => "St. James", "5126" => "St. James", "5127" => "St. James", "5128" => "St. James", "5129" => "St. James", "5130" => "St. Jacob", "5131" => "St. Ignatius", "5132" => "St. Ignace", "5133" => "St. Hilaire", "5134" => "St. Henry", "5135" => "St. Helens", "5136" => "St. Helena County", "5137" => "St. Helena", "5138" => "St. Helena", "5139" => "St. Helena", "5140" => "St. Helen", "5141" => "St. Hedwig", "5142" => "St. Georges", "5143" => "St. George Island", "5144" => "St. George Island", "5145" => "St. George", "5146" => "St. George", "5147" => "St. George", "5148" => "St. George", "5149" => "St. George", "5150" => "St. George", "5151" => "St. Gabriel", "5152" => "St. Francois County", "5153" => "St. Francisville", "5154" => "St. Francisville", "5155" => "St. Francisville", "5156" => "St. Francis County", "5157" => "St. Francis", "5158" => "St. Francis", "5159" => "St. Francis", "5160" => "St. Francis", "5161" => "St. Francis", "5162" => "St. Florian", "5163" => "St. Elmo", "5164" => "St. Elizabeth", "5165" => "St. Edward", "5166" => "St. Donatus", "5167" => "St. David", "5168" => "St. David", "5169" => "St. Croix Falls", "5170" => "St. Croix County", "5171" => "St. Cloud", "5172" => "St. Cloud", "5173" => "St. Cloud", "5174" => "St. Cloud", "5175" => "St. Clement", "5176" => "St. Clairsville", "5177" => "St. Clairsville", "5178" => "St. Clair Shores", "5179" => "St. Clair County", "5180" => "St. Clair County", "5181" => "St. Clair County", "5182" => "St. Clair", "5183" => "St. Clair", "5184" => "St. Clair", "5185" => "St. Clair", "5186" => "St. Clair", "5187" => "St. Charles County", "5188" => "St. Charles County", "5189" => "St. Charles", "5190" => "St. Charles", "5191" => "St. Charles", "5192" => "St. Charles", "5193" => "St. Charles", "5194" => "St. Charles", "5195" => "St. Charles", "5196" => "St. Charles", "5197" => "St. Charles", "5198" => "St. Charles", "5199" => "St. Bonifacius", "5200" => "St. Bonaventure", "5201" => "St. Bernice", "5202" => "St. Bernard", "5203" => "St. Bernard", "5204" => "St. Benedict", "5205" => "St. Augustine South", "5206" => "St. Augustine Shores", "5207" => "St. Augustine Beach", "5208" => "St. Augustine", "5209" => "St. Augustine", "5210" => "St. Augusta", "5211" => "St. Anthony", "5212" => "St. Anthony", "5213" => "St. Anthony", "5214" => "St. Ansgar", "5215" => "St. Anne", "5216" => "St. Ann Highlands", "5217" => "St. Ann", "5218" => "St. Andrews", "5219" => "St. Albans", "5220" => "St. Albans", "5524" => "South St. Paul", "6860" => "Sault Ste. Marie", "9420" => "Port St. Lucie", "9421" => "Port St. John", "9422" => "Port St. Joe", "11989" => "North St. Paul", "15376" => "Marine on St. Croix", "16006" => "Luis M. Cintrón", "17598" => "Lake St. Louis", "17599" => "Lake St. Croix Beach", "18797" => "K. I. Sawyer", "19284" => "J.F. Villareal", "21482" => "H. Rivera Colón", "21483" => "H. Cuellar Estates", "22445" => "Glen St. Mary", "23008" => "G. L. García", "25285" => "East St. Louis", "25534" => "E. Lopez", "29469" => "Cape St. Claire", "32160" => "Bay St. Louis", );

        $nw_arr = array();
        if (!empty($dot_arr)) {
            $nw_i = 0;
            foreach ($dot_arr as $ky => $da) {
                $da_new = str_replace(".", "-", $da);
                $da_new = str_replace(" ", "-", $da_new);
                $da_new = str_replace("--", "-", $da_new);
                $nw_arr[$nw_i]['slug'] = strtolower($da_new);
                $nw_arr[$nw_i]['name'] = $da;
                $nw_i++;
            }
        }

        if(!empty($nw_arr)){
            $key = array_search($city_slug, array_column($nw_arr, 'slug'));

            if($key != ""){
                $city = $nw_arr[$key]['name'];
            }
        }

        // CITY DATA
        if (strpos($city_slug, '-county') !== false) {
            $city_data = DB::select('SELECT * FROM `counties` WHERE `state_name` LIKE "%' . $state . '%" AND `name` = "' . $city . '" AND `type`="County"');
        }else{
            $city_data = DB::select('SELECT * FROM `counties` WHERE `state_name` LIKE "%' . $state . '%" AND `name` = "' . $city . '" AND `type`="City"');
        }

        // GET PRACTICE AREAS
        $p_areas = array();
        $list_parea = array();

        $list_pa = DB::select('SELECT * FROM `listing_practice_area`');
        $practice_a = DB::select('SELECT * FROM `practice_areas` ORDER BY `name` ASC');

        if (!empty($list_pa)) {
            foreach ($list_pa as $lpa) {
                array_push($list_parea, $lpa->practice_area_id);
            }
            $list_parea = array_unique($list_parea);
        }

        if (!empty($practice_a) && !empty($list_pa)) {
            foreach ($practice_a as $p_a) {
                if (in_array($p_a->id, $list_parea)) {
                    $p_areas[$p_a->id]['name'] = $p_a->name;
                    $p_areas[$p_a->id]['slug'] = $p_a->slug;
                }
            }
        }

        $data["p_areas"] = $p_areas;

        $practiceArea = PracticeArea::where('slug', $p_area)->first();
        if (empty($practiceArea)) {
            return abort(404);
        }

        $statedt = State::where('name', $state)->first();
        $countydt = County::where('name', $city)->where('state_name', $state)->first();
        
        if (strpos($city_slug, '-county') !== false) {
            $countydt = County::where('name', $city)->where('type', 'County')->where('state_name', $state)->first();
        }else{
            $countydt = County::where('name', $city)->where('type', 'City')->where('state_name', $state)->first();
        }
        
        if ($statedt == null || $countydt == null) {
            return abort(404);
        }

        // SET META
        $title = "Best $practiceArea->name Lawyers in $city, $state | Legal.com";
        $m_des = "Connect with the top $practiceArea->name attorneys in $city. Explore our list on Legal.com to find experienced legal representation in $city and achieve the best possible outcome for your case.";

        $meta = array(
            "meta_title" => $title,
            "meta_description" => $m_des
        );
        $page = (object) ['extras' => $meta, "title" => $title];

        // GET CONTENT
        $content = array();
        $cdata = array();
        if(($practiceArea != null) && ($statedt != null) && ($countydt != null)){
            if ($practiceArea->id != "" && $statedt->id != "" && $countydt->id != "") {
                $content = DB::table('practice_area_state_county_content')
                ->where('practiceArea', $practiceArea->id)
                ->where('state', $statedt->id)
                ->where('county', $countydt->id)->first();

                if(empty($content)){
                    $content = DB::table('practice_area_state_city_content')
                    ->where('practiceArea', $practiceArea->id)
                    ->where('state', $statedt->id)
                    ->where('county', $countydt->id)->first();
                }

                if (!empty($content)) {
                    $cdata = json_decode($content->extras);

                    if (isset($cdata->meta_title) && $cdata->meta_title != "") {
                        $title = $cdata->meta_title;
                    }
                    if (isset($cdata->meta_description) && $cdata->meta_description != "") {
                        $m_des = $cdata->meta_description;
                    }

                    $meta = array(
                        "meta_title" => $title,
                        "meta_description" => $m_des
                    );
                    $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $content->url_index];
                }
            } else {
                return abort(404);
            }
        }

        // GET LAWYERS
        $practiceArea = PracticeArea::where('slug', $p_area)->first();

        $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->with('jurisdiction')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
            $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
        })->whereHas('address', function ($query) use ($state) {
            $query->where('state', $state);
        })->whereHas('address', function ($query) use ($city) {
            $query->where('city', $city);
            $query->orwhere('county', $city);
        })->orderby('featured', 'DESC')->paginate(6);

        return view('lawyers/lawyers_parea_state_page', ['page' => $page, 'p_area' => $practiceArea->name, 'state' => $state, 'city' => $city, 
            'lawyers' => $lawyers, 'data' => $data, 'content' => $content, 'cdata' => $cdata, 'p_area_data' => $practiceArea])->withShortcodes();
    }

    // url = /lawyers/ [PA] || [State]
    public function lawyer_old_pa_or_s_links($slug)
    {
        $practiceArea = PracticeArea::where('slug', $slug)->first();

        if ($practiceArea) {
            return redirect(url('/') . '/lawyers/pa/' . $slug, 301);
        } else {
            $state = ucwords(str_replace("-", " ", $slug));
            $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');

            if (!empty($state_data)) {
                return redirect(url('/') . '/lawyers/loc/' . $slug, 301);
            } else {
                return abort(404);
            }
        }
    }

    // url = /lawyers/ [PA] || [State] / [State] || [County] || [City]
    public function lawyer_old_pa_and_s_links($slug, $slug2)
    {   
        $practiceArea = PracticeArea::where('slug', $slug)->first();

        if ($practiceArea) {
            $state = ucwords(str_replace("-", " ", $slug2));
            $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');

            if (!empty($state_data)) {
                return redirect(url('/') . '/lawyers/pa/' . $slug . '/' . $slug2, 301);
            } else {
                return abort(404);
            }
        } else {
            $state = ucwords(str_replace("-", " ", $slug));
            $city = ucwords(str_replace("-", " ", $slug2));
            $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');

            if (!empty($state_data)) {
                $city_types = array();
                $city_data = DB::select('SELECT * FROM `counties` WHERE `state_name` LIKE "%' . $state . '%" AND `name` = "' . $city . '"');

                if (!empty($city_data)) {
                    foreach($city_data as $cdata){
                        array_push($city_types,trim($cdata->type));
                    }

                    if(in_array("City",$city_types)){
                        $slug2 = $slug2;
                    }elseif($city_data[0]->type == "County"){
                        $slug2 = $slug2 . '-county';
                    }

                    return redirect(url('/') . '/lawyers/loc/' . $slug . '/' . $slug2, 301);
                } else {
                    return abort(404);
                }

            } else {
                return abort(404);
            }
        }
    }

    // url = /lawyers/ [PA] / [State] / [County] || [City]
    public function lawyer_old_pa_and_s_and_c_links($slug, $slug2, $slug3)
    {   
        $practiceArea = PracticeArea::where('slug', $slug)->first();

        if ($practiceArea) {
            $state = ucwords(str_replace("-", " ", $slug2));
            $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');

            if (!empty($state_data)) {
                $city_types = array();
                $city = ucwords(str_replace("-", " ", $slug3));
                $city_data = DB::select('SELECT * FROM `counties` WHERE `state_name` LIKE "%' . $state . '%" AND `name` = "' . $city . '"');

                if (!empty($city_data)) {
                    foreach($city_data as $cdata){
                        array_push($city_types,trim($cdata->type));
                    }

                    if(in_array("City",$city_types)){
                        $slug3 = $slug3;
                    }elseif($city_data[0]->type == "County"){
                        $slug3 = $slug3 . '-county';
                    }

                    return redirect(url('/') . '/lawyers/pa/' . $slug . '/' . $slug2 . '/' . $slug3, 301);
                } else {
                    return abort(404);
                }
            } else {
                return abort(404);
            }
        } else {
            return abort(404);
        }
    }

    // add lawyer review - /add_lawyer_review
    public function add_lawyer_review(Request $request)
    {
        $rate = $request->rate;
        $rev_comment = $request->rev_comment;
        $rev_u_id = $request->rev_u_id;
        $rev_l_id = $request->rev_l_id;

        if ($rate != "" && $rev_comment != "" && $rev_u_id != "" && $rev_l_id != "") {

            $lr_id = DB::table('listing_reviews')->insertGetId([
                'listing_id' => $rev_l_id,
                'user_id' => $rev_u_id,
                'comment' => $rev_comment,
                'rating' => $rate,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);

            if ($lr_id) {
                $ahtml = "";
                $avg = 0;
                $reviews = DB::table('listing_reviews')->where('listing_id', $rev_l_id)->where('approved', 'yes')->get();

                if ($reviews->count() > 0) {
                    $avg = ceil($reviews->sum('rating') / $reviews->count());

                    foreach ($reviews as $rev) {
                        $user = DB::table('users')->where('id', $rev->user_id)->first();

                        $ahtml .= '<div class="lawyer-reviews-col">';
                        $ahtml .= '<div class="lawyer-reviews-card">';
                        // $ahtml .= '<h3>Auto accident</h3>';
                        $ahtml .= '<p>' . $rev->comment . '</p>';
                        $ahtml .= '<div class="lawyer-reviews-bottom">';
                        $ahtml .= '<h4>' . $user->name . '</h4>';
                        $ahtml .= '<span class="lawyer-reviews-stars-rating" rating="' . $rev->rating . '">';
                        $ahtml .= '<span class="star"></span>';
                        $ahtml .= '<span class="star"></span>';
                        $ahtml .= '<span class="star"></span>';
                        $ahtml .= '<span class="star"></span>';
                        $ahtml .= '<span class="star"></span>';
                        $ahtml .= '</span>';
                        $ahtml .= '</div>';
                        $ahtml .= '</div>';
                        $ahtml .= '</div>';
                    }
                }

                return json_encode(
                    array(
                        'error' => '',
                        'success' => 'Review added',
                        'total_reviews' => $reviews->count(),
                        'average' => $avg,
                        'all_rev_html' => $ahtml
                    )
                );
            } else {
                return json_encode(array('error' => 'Something Went Wrong'));
            }

        } else {
            return json_encode(array('error' => 'Something Went Wrong'));
        }
    }

    // LAWYER CONTACT
    public function contact_lawyer(Request $request)
    {
        if ($request->lawyer_id != "") {
            $listing = Listing::where('id', $request->lawyer_id)->first();
            if (!empty($listing) && $listing->count() != 0) {
                Mail::to($listing->email)->send(new LawyerContactEmail($request));
                // Mail::to("nathan.ahmedabad@gmail.com")->send(new LawyerContactEmail($request));

                return json_encode(array('e_code' => 0, 'success' => 'Inquiry Sent.', 'error' => ''));
            } else {
                return json_encode(array('e_code' => 0, 'success' => '', 'error' => 'Something went wrong'));
            }
        } else {
            return json_encode(array('e_code' => 0, 'success' => '', 'error' => 'Something went wrong'));
        }
    }

    // pagination - /lawyers_paginate
    // public function ic_lawyers_paginate(Request $request)
    // {   
    //     $p_area = $request->p_area;
    //     $state = $request->state;
    //     $city = $request->city;

    //     $practiceArea = PracticeArea::where('name', $p_area)->first();

    //     if($city != ""){
    //         $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
    //             $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
    //         })->whereHas('address', function ($query) use ($state) {
    //             $query->where('state', $state);
    //         })->whereHas('address', function ($query) use ($city) {
    //             $query->where('city', $city);
    //         })->paginate(6);
    //     }else{
    //         $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
    //             $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
    //         })->whereHas('address', function ($query) use ($state) {
    //             $query->where('state', $state);
    //         })->paginate(6);
    //     }

    //     $s_arr = array('p_area','state','lawyers');
    //     return view('lawyers/lawyers_pagination', compact($s_arr))->render();
    // }

    // public function filterLawyers(Request $request)
    // {
    //     $minExperience = $request->input('min_experience');
    //     $maxExperience = $request->input('max_experience');

    //     $lawyers = Lawyer::whereBetween('years_of_experience', [$minExperience, $maxExperience])->get();

    //     return response()->json($lawyers);
    // }
}
