<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\ListingverificationRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use App\Mail\VerificationListingEmail;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use App\Models\User;

/**
 * Class ListingverificationCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class ListingverificationCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Listingverification::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/listingverification');
        CRUD::setEntityNameStrings('listing verification', 'listing verifications');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
//        CRUD::column('user_id')->type('text');

        CRUD::column('user_id')->type('select')->label('Requested by')
        ->entity('requestedByUser')
        ->attribute('name')
        ->model('App\Models\User');

        CRUD::column('verified')->type('text');

        CRUD::column('verified_by_user_id')->type('select')->label('Verified By')
        ->entity('verifiedByUser') 
        ->attribute('name')
        ->model('App\Models\User'); 

        CRUD::column('created_at')->label('Requested at')->type('date');

        CRUD::column('verified_at')->label('Verified at')->type('date');
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(ListingverificationRequest::class);
        // CRUD::setFromDb(); // set fields from db columns.

        CRUD::field([ 
            'label'   => 'Verified',
            'type'    => 'select_from_array',
            'name'    => 'verified',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);

        CRUD::field([
            'name'  => 'verification_documents',
            'label' => 'Verification Documents',
            'type'  => 'show_verification_docs'
        ]);
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();

        $entry = $this->crud->getCurrentEntry();

        CRUD::field('verified')->events([
            'updating' => function ($entry) {
                if (backpack_user()->id) {
		    $verified_by_user_id = backpack_user()->id;
                    $entry->verified_by_user_id = $verified_by_user_id;
                    $entry->verified_at = date('Y-m-d H:i:s');
                }
            },
            'saved' => function ($entry) {
                $user = User::find($entry->user_id);
                if ($user->referral_id != "") {
                    $cur_usr = User::find($user->referral_id);
                    $new_usr = $user;

                    DB::table('user_referral')->insertGetId([
                        'current_user_id' => $cur_usr->id,
                        'new_user_id' => $new_usr->id,
                        'current_user_email' => $cur_usr->email,
                        'new_user_email' => $new_usr->email,
                        'make_premium' => '1',
                        'updated_at' => date('Y-m-d H:i:s'),
                    ]);
                }

                Mail::to($user->email)->send(new VerificationListingEmail($user, $entry));
            },
        ]);

    }
}

