jQuery(document).ready(function(){
	// HIDE ERRORS ON LOAD
	jQuery(".err").text("");
	jQuery(".err").fadeOut();
	jQuery(".form_res").fadeOut();
	jQuery(".form_res #form_loading").fadeOut();
	jQuery(".form_res #l_form_message").fadeOut();

	function errorFadeIn(text,ele) {
		jQuery(ele).parent().find(".err").fadeIn();
		jQuery(".err").css("color", "#b70c0c");
		jQuery(ele).parent().find(".err").text(text);
		setTimeout(() => {
			jQuery(".err").fadeOut();
		}, 5000);
		return false;
	}

	function errorFadeOut() {
		jQuery(".err").fadeOut();
		jQuery(".err").css("color", "#fff");
		jQuery(".err").text("");
	}

	// CHECK IS EMAIL
	function isEmail(email) {
		var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
		return regex.test(email);
	}

	// select dropdown js
	jQuery(".support-drop-down .support-selected a").click(function() {
		jQuery(this).toggleClass('selected-a');
		jQuery(".support-drop-down .support-options").toggle();
	});
	jQuery(".support-drop-down .support-options ul li a").click(function() {
		var text = jQuery(this).attr('value');
		jQuery(".support-drop-down .support-options ul li a").removeClass('select-value');
		jQuery(this).addClass('select-value');
		jQuery(this).parent().parent().parent().parent().find('.support-selected a span').html(text);
		jQuery(".support-drop-down .support-options").hide();
	}); 
	jQuery(document).bind('click', function(e) {
		var jQueryclicked = jQuery(e.target);
		if (! jQueryclicked.parents().hasClass("support-drop-down"))
			jQuery(".support-drop-down .support-options").hide();
	});

	// ON FILE CHANGE
	var formData = new FormData();
	var fileExtension = ['docs', 'pdf'];
	$('input[type=file]').change(function () {
		$(this).parent().find(".info").css({"display":"unset"});
		$(this).parent().find(".file_info").text("").css({"display":"none"});

		var file = $(this)[0].files[0];
		var id = $(this).attr("id");
		var name = file.name;

		if(file == undefined || file == ""){
			errorFadeIn("Please Select File", "#"+id);
		}else if ($.inArray(name.split('.').pop().toLowerCase(), fileExtension) == -1) {
			errorFadeIn("Only this formats are allowed : "+fileExtension.join(', '), "#"+id);
		}else if(file.size > 5000000){
			errorFadeIn("Please Select File < 10MB", "#"+id);
		}else{
			$(this).parent().find(".info").css({"display":"none"});
			$(this).parent().find(".file_info").text(name).css({"display":"unset"});

			formData.append(id, file);
		}
	});

	// FORM SUBMISSION
	$("#apply_job_btn").click(function(e) {
		e.preventDefault();

		var full_name = $("#full_name").val();
		var email = $("#email").val();

		if (full_name.length == 0) {
			errorFadeIn("Enter valid full name.","#full_name");
		}else if (email.length == 0) {
			errorFadeIn("Enter your email addresss","#email");
		}else if(!isEmail(email)){
			errorFadeIn("Enter valid email addresss","#email");
		}else if($(".r_f_info").text() == ""){
			errorFadeIn("Please select file","#Resume");
		}else if($(".m_f_info").text() == ""){
			errorFadeIn("Please select file","#motivational-letter");
		}else{
			formData.append("full_name", $("#full_name").val());
			formData.append("email", $("#email").val());
			formData.append("job_id", $("#job_id").val());

			$.ajaxSetup({
				headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
			});

			$("#apply_job_btn").css("pointer-events", "none");
			errorFadeOut(".error");
			jQuery(".form_res").fadeIn();
			jQuery(".form_res #form_loading").fadeIn();

			$.ajax({
				url: job_url,
				type: "POST",
				data: formData,
				processData: false,
				contentType: false,
				success: function (response) {
					var response = JSON.parse(response);

					jQuery(".form_res #form_loading").fadeOut();

					if(response.error == ""){
						jQuery(".form_res #l_form_message").text(response.success);
						jQuery(".form_res #l_form_message").fadeIn();
					}else{
						$("#apply_job_btn").css("pointer-events", "all");
						jQuery(".form_res #l_form_message").text(response.error);

						jQuery(".form_res").fadeOut();
					}

					setTimeout(function(){ 
						jQuery(".err").text("");
						jQuery(".err").fadeOut();
						jQuery(".form_res").fadeOut();
						jQuery(".form_res #l_form_message").text("");
						jQuery(".form_res #l_form_message").fadeOut();
					}, 2000);
				},
			});
		}
	});
});