<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\DyformRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;
use Backpack\CRUD\app\Library\Widget;

/**
 * Class DyformCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class DyformCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Dyform::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/dyform');
        CRUD::setEntityNameStrings('dyform', 'dyforms');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        // CRUD::setFromDb(); // set columns from db columns.
        CRUD::column('form_name')->type('text');

        $this->crud->addColumn([
            'name'  => 'form_fild',
            'label' => 'Fild',
            'type'  => 'text',
            'limit'  => 50,
        ]);
        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        Widget::add()->type('script')->content('js/dyfrom.js');
        CRUD::setValidation(DyformRequest::class);
        // CRUD::setFromDb(); // set fields from db columns.

        CRUD::field('form_name')->type('text');

        CRUD::field([   // repeatable
            'name'  => 'form_fild',
            'label' => 'Form Fild',
            'type'  => 'repeatable',
            'subfields' => [ // also works as: "fields"
                [
                    'name'    => 'fild_lable',
                    'type'    => 'text',
                    'label'   => 'Fild Lable',
                    'wrapper' => ['class' => 'form-group col-md-4'],
                ],
                [
                    'name'        => 'fild_type',
                    'label'       => "Fild Type",
                    'type'        => 'select2_from_array',
                    'options'     => [  
                                        'checkbox' =>'checkbox',
                                        'color' =>'color',
                                        'date' =>'date',
                                        'datetime-local' =>'datetime-local',
                                        'email' =>'email',
                                        'month' =>'month',
                                        'number' =>'number',
                                        'password' =>'password',
                                        'radio' =>'radio',
                                        'reset' =>'reset',
                                        'submit' =>'submit',
                                        'tel' =>'tel',
                                        'text' =>'text',
                                        'time' =>'time',
                                        'url' =>'url',
                                        'week' =>'week'
                                    ],
                    'allows_null' => true,
                    // 'default'     => 'text',
                ],
                [
                    'name'  => 'list',
                    'type'  => 'textarea',
                    'lable' => 'List For Checkbox Or Radio Button',
                    'attributes' => [
				       'disabled'    => 'disabled',
				     ],
                ],
                [   
                    'name'  => 'switch',
                    'type'  => 'switch',
                    'label'    => 'Required',

                    // optional
                    'color'    => 'primary', // May be any bootstrap color class or an hex color
                    'onLabel' => '✓',
                    'offLabel' => '✕',
                ],
            ],
        ]);
        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();

    }
}
