<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class ContactUsEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $request;

    /**
     * Create a new message instance.
     */
    public function __construct($request)
    {
	$this->request = $request;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Contact us inquiry | Legal.com',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
	
        return new Content(
            view: 'emails.contact-us',
        );
	

    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }

	public function build()
	{

		$this->subject('Contact us inquiry | Legal.com')
	         ->from('no-reply@legal.com')
	         ->view('emails.contact-us')
		 ->with(['request' => $this->request]);

	    return $this;
	}

}
