@php
    use App\Models\Shortcode;
    use App\Models\Theme2;
    use App\Models\Theme3;
    use App\Models\Dyform;
    use Vedmant\LaravelShortcodes\Facades\Shortcodes;
    use Illuminate\Support\Facades\Route;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\DB;
    use Illuminate\Support\Facades\View;

    Shortcodes::add('Date', function ($atts, $content, $tag, $manager) {
        return date('F d,Y');
    });

    Shortcodes::add('Month', function ($atts, $content, $tag, $manager) {
        return date('F');
    });

    Shortcodes::add('Year', function ($atts, $content, $tag, $manager) {
        return date('Y');
    });

    Shortcodes::add('State', function ($atts, $content, $tag, $manager) {
        $routeArray = app('request')
            ->route()
            ->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        [$controller, $r_name] = explode('@', $controllerAction);

        $request = request();
        $state = "";

        if ($r_name == 'lawyers_pa_or_s') {
            $state = request('slug', $request);
        }

        if ($r_name == 'lawyers_pa_and_s') {
            $state = request('p_area', $request);
            $city = request('state', $request);

            if ($state != '') {
                $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');
                if (!empty($state_data)) {
                    return $state_data[0]->name;
                } else {
                    $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $city . '%"');

                    return $state_data[0]->name;
                }
            }
        }

        if ($r_name == 'lawyers_pa_and_s_and_c') {
            $state = request('state', $request);
        }

        if ($state != '') {
            $state_data = DB::select('SELECT * FROM `states` WHERE `name` LIKE "%' . $state . '%"');

            if (!empty($state_data)) {
                return $state_data[0]->name;
            }
        }

        return '';
    });

    Shortcodes::add('City', function ($atts, $content, $tag, $manager) {
        $routeArray = app('request')
            ->route()
            ->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        [$controller, $r_name] = explode('@', $controllerAction);

        $request = request();

        if ($r_name == 'lawyers_pa_and_s_and_c') {
            $city = request('city', $request);
        }

        if ($city != '') {
            $city_data = DB::select('SELECT * FROM `counties` WHERE `type`="City" AND `name` LIKE "%' . $city . '%" ORDER BY name ASC');

            if (!empty($city_data)) {
                return $city_data[0]->name;
            }
        }

        return '';
    });

    Shortcodes::add('County', function ($atts, $content, $tag, $manager) {
        $routeArray = app('request')
            ->route()
            ->getAction();
        $controllerAction = class_basename($routeArray['controller']);
        [$controller, $r_name] = explode('@', $controllerAction);

        $request = request();

        if ($r_name == 'lawyers_pa_and_s_and_c') {
            $city = request('city', $request);
        }

        if ($city != '') {
            $city_data = DB::select('SELECT * FROM `counties` WHERE `type`="County" AND `name` LIKE "%' . $city . '%" ORDER BY name ASC');

            if (!empty($city_data)) {
                return $city_data[0]->name;
            }
        }

        return '';
    });

    $shortcodes = Shortcode::all();
    foreach($shortcodes as $shortcode){
        Shortcodes::add($shortcode->name, function ($atts, $content, $tag, $manager) use ($shortcode) {
            $data = [
                'heading' => $shortcode->heading,
                'content' => $shortcode->content,
                'button_text' => $shortcode->button_text,
                'link' => $shortcode->link,
            ];
            $viewContent = View::make('short-code-1', $data)->render();
            return $viewContent;
        });
    }

    $theme2s = Theme2::all();
    foreach($theme2s as $theme2){
        Shortcodes::add($theme2->name, function ($atts, $content, $tag, $manager) use ($theme2) {
            $data = [
                'heading' => $theme2->heading,
                'content' => $theme2->content,
                'button_text' => $theme2->button_text,
                'link' => $theme2->link,
            ];
            $viewContent = View::make('short-code-2', $data)->render();
            return $viewContent;
        });
    }

    $theme3s = Theme3::all();
    foreach($theme3s as $theme3){
        Shortcodes::add($theme3->name, function ($atts, $content, $tag, $manager) use ($theme3) {
            $data = [
                'heading' => $theme3->heading,
                'content' => $theme3->content,
                'button_text' => $theme3->button_text,
                'link' => $theme3->link,
            ];
            $viewContent = View::make('short-code-3', $data)->render();
            return $viewContent;
        });
    }

    $dyforms = Dyform::all();
    foreach($dyforms as $dyform){
        Shortcodes::add($dyform->form_name, function ($atts, $content, $tag, $manager) use ($dyform) {
            $data = [
                'form_name' => $dyform->form_name,
                'form_fild' => $dyform->form_fild,
            ];
            $viewContent = View::make('form', $data)->render();
            return $viewContent;
        });
    }

@endphp
