<?php

namespace App\Listeners;

use App\Events\ListingValidated;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use App\Mail\VerificationListingEmail;

class SendValidationEmail
{
    /**
     * Create the event listener.
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     */
    public function handle(ListingValidated $event): void
    {
	Mail::to($event->user->email)->send(new VerificationListingEmail($event->user, $event->entry));
    }
}
