<?php
$breadcrumbs = [
    trans('backpack::crud.admin') => backpack_url('dashboard'),
    trans('backpack::backup.backups') => false,
];
?>

<?php $__env->startSection('header'); ?>
<section class="container-fluid" bp-section="page-header">
    <h1 bp-section="page-heading" class="text-capitalize"><?php echo e(trans('backpack::backup.backups')); ?></h1>
</section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<button id="create-new-backup-button" href="<?php echo e(url(config('backpack.base.route_prefix', 'admin').'/backup/create')); ?>" class="btn btn-primary mb-2">
    <i class="la la-spinner"></i>
    <i class="la la-plus"></i>
    <span><?php echo e(trans('backpack::backup.create_a_new_backup')); ?></span>
</button>

<div class="card">
    <div class="card-body p-0">
        <table class="table table-hover pb-0 mb-0">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php echo e(trans('backpack::backup.location')); ?></th>
                    <th><?php echo e(trans('backpack::backup.date')); ?></th>
                    <th class="text-right"><?php echo e(trans('backpack::backup.file_size')); ?></th>
                    <th class="text-right"><?php echo e(trans('backpack::backup.actions')); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $backups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $backup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($key + 1); ?></td>
                    <td><?php echo e($backup->diskName); ?></td>
                    <td><?php echo e($backup->lastModified); ?></td>
                    <td class="text-right"><?php echo e($backup->fileSize); ?> MB</td>
                    <td class="text-right">
                        
                        <?php if($backup->downloadLink): ?>
                        <a class="btn btn-sm btn-link" data-button-type="download" href="<?php echo e($backup->downloadLink); ?>">
                            <i class="la la-cloud-download"></i> <?php echo e(trans('backpack::backup.download')); ?>

                        </a>
                        <?php endif; ?>
                        <p><?php echo e($backup->fileName); ?></p>
                        <!-- <p>hi</p> -->
                        <a class="btn btn-sm btn-link" data-button-type="delete" href="<?php echo e($backup->deleteLink); ?>">
                            <i class="la la-trash-o"></i> <?php echo e(trans('backpack::backup.delete')); ?>

                        </a>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_styles'); ?>
<style>
    #create-new-backup-button.loading>.la-spinner {
        display: inherit;
        animation: rotation 1s steps(8, end) infinite;
    }

    #create-new-backup-button>.la-spinner,
    #create-new-backup-button.loading>.la-plus {
        display: none;
    }

    @keyframes rotation {
        from {
            transform: rotate(0deg);
        }

        to {
            transform: rotate(359deg);
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('after_scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', () => {
        const storageKey = 'backpack.backupmanager.created';
        const createButton = document.querySelector('#create-new-backup-button');
        const deleteButtons = document.querySelectorAll('[data-button-type=delete]');
        const downloadButtons = document.querySelectorAll('[data-button-type=download]');
        const defaultHeaders = { 
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content,
            'Accept': 'application/json',
        };

        const trans = {
            create_confirmation_title: "<?php echo e(trans('backpack::backup.create_confirmation_title')); ?>",
            create_started_message: "<?php echo e(trans('backpack::backup.create_started_message')); ?>",
            create_error_title: "<?php echo e(trans('backpack::backup.create_error_title')); ?>",
            create_completed_title: "<?php echo e(trans('backpack::backup.create_completed_title')); ?>",
            download_confirmation_title: "<?php echo e(trans('backpack::backup.download_confirmation_title')); ?>",
            delete_error_title: "<?php echo e(trans('backpack::backup.delete_error_title')); ?>",
            delete_confirm: "<?php echo e(trans('backpack::backup.delete_confirm')); ?>",
            delete_cancel_title: "<?php echo e(trans('backpack::backup.delete_cancel_title')); ?>",
            delete_cancel_message: "<?php echo e(trans('backpack::backup.delete_cancel_message')); ?>",
            delete_confirmation_title: "<?php echo e(trans('backpack::backup.delete_confirmation_title')); ?>",
            delete_confirmation_message: "<?php echo e(trans('backpack::backup.delete_confirmation_message')); ?>",
        }

        // Noty alert helper
        const notyAlert = (title, message = '', type = 'success') => new Noty({text: `<strong>${title}</strong><br>${message}`, type}).show();

        // Set button status helper
        const setCreateButtonLoading = status => {
            createButton.classList.toggle('loading', status);
            createButton.toggleAttribute('disabled', status);
        }

        // capture the Create new backup button
        createButton.onclick = async e => {
            e.preventDefault();

            setCreateButtonLoading(true);
            notyAlert(trans.create_confirmation_title, trans.create_started_message);

            // do the backup through ajax
            try {
                let response = await fetch(createButton.getAttribute('href'), {
                    method: 'PUT', 
                    headers: defaultHeaders
                });

                let result = await response.text();

                // Show an alert with the result
                if(!response.ok || result.includes('failed')) {
                    throw new Error(result);
                }

                localStorage.setItem(storageKey, true);
                location.reload();
            }
            catch (result) {
                // Show an alert with the result
                notyAlert(trans.create_error_title, result, 'warning');
            }

            setCreateButtonLoading(false);
        }

        // capture the delete button
        deleteButtons.forEach(deleteButton => {
            deleteButton.onclick = async e => {
                e.preventDefault();

                if (!confirm(trans.delete_confirm)) {
                    return notyAlert(trans.delete_cancel_title, trans.delete_cancel_message, 'info');
                }

                try {
                    let response = await fetch(deleteButton.getAttribute('href'), {
                        method: 'DELETE', 
                        headers: defaultHeaders
                    });

                    let result = await response.text();

                    // Show an alert with the result
                    if(!response.ok) {
                        throw new Error(result);
                    }

                    notyAlert(trans.delete_confirmation_title, trans.delete_confirmation_message);

                    // delete the row from the table
                    deleteButton.closest('tr').remove();
                }
                catch (result) {
                    // Show an alert with the result
                    notyAlert(trans.delete_error_title, result, 'warning');
                }
            }
        });

        // capture the download button
        downloadButtons.forEach(downloadButton => {
            downloadButton.onclick = e => notyAlert(trans.download_confirmation_title);
        });

        // Show messages stored on session
        if(localStorage.getItem(storageKey)) {
            localStorage.removeItem(storageKey);
            notyAlert(trans.create_completed_title);
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make(backpack_view('blank'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/backupmanager/backup.blade.php ENDPATH**/ ?>