<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateGlossaryTranslationsTable extends Migration
{
    public function up()
    {
        Schema::create('glossary_translations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('glossary_id');
            $table->string('locale')->index();
            $table->string('word');
            $table->text('definition');

            $table->unique(['glossary_id', 'locale']);
        });
    }

    public function down()
    {
        Schema::dropIfExists('glossary_translations');
    }
}
