<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\CountyRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class CountyCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class CountyCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\County::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/county');
        CRUD::setEntityNameStrings('county', 'counties');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        CRUD::setColumns(['name', 'type', 'state_name']);
        CRUD::column([
            'name'  => 'view_link',
            'label' => 'View Front',
            'type'  => 'model_function',
            'function_name' => 'getfrontlink', 
            'limit' => 10000,
            'escaped' => false,
        ]);
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
//        CRUD::setValidation(CountyRequest::class);
//        CRUD::setFromDb(); // set fields from db columns.
        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);
        CRUD::field('name')->type('text');
        CRUD::field('name')->type('text');
        CRUD::field('name_ascii')->type('text');
        CRUD::field('type')->type('text');
        CRUD::field('county_fips')->type('text');
        CRUD::field('state_id')->type('text');
        CRUD::field('state_name')->type('text');
        CRUD::field('h1_title')->type('text')->label('H1 Title');
        CRUD::field('short_content')->type('summernote')->label('Short content');
        CRUD::field('h2_title_asc')->type('text')->label('H2 After Short Content');
        CRUD::field('description')->type('summernote')->label('Description');

        CRUD::field([
            'tab'           => 'Frequently Asked Questions',
            'label'         => 'FAQs',
            'type'          => "relationship",
            'model'         => 'App\Models\CountyFaq',
            'pivot'         => true,
            'entity'        => 'faqs',
            'name'          => 'faqs',
            'subfields'   => [
                [
                    'name' => 'title',
                    'label' => 'Title',
                    'type' => 'text',
                    'wrapper' => [
                        'class' => 'form-group col-md-12',
                    ],
                ],

                [
                    'name' => 'answer',
                    'label' => 'Answer',
                    'type' => 'textarea',
                    'wrapper' => [
                        'class' => 'form-group col-md-12',
                    ],
                ],
            ],
        ]);

        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }

}
