<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;
use Illuminate\Support\Facades\Log;
use App\Models\Cron_testing;

class Kernel extends ConsoleKernel
{
    /**
     * Define the application's command schedule.
     */
    protected function schedule(Schedule $schedule)
    {
        // $schedule->command('backup:clean')->dailyAt('9:05')
        //     ->onFailure(function () {
        //         Log::error('Backup clean failed!');
        //     })
        //     ->onSuccess(function () {
        //         Log::info('Backup clean succeeded!');
        //     });

        // $schedule->command('backup:run')->daily()->at('18:00')
        //     ->onFailure(function () {
        //         Log::error('Backup run failed!');
        //     })
        //     ->onSuccess(function () {
        //         Log::info('Backup run succeeded!');
        //     });

        // $schedule->command('backup:run --only-files')->everyMinute()
        //     ->onFailure(function () {
        //         Log::error('Backup run failed!');
        //     })
        //     ->onSuccess(function () {
        //         Log::info('Backup run succeeded!');
        //     });

        $schedule->command('backup:run')->everyMinute()
            ->onFailure(function () {
                Log::error('Backup run failed!');
            })
            ->onSuccess(function () {
                Log::info('Backup run succeeded!');
            });

            // $schedule->command('backup:clean')->everyMinute()
            // ->onFailure(function () {
            //     Log::error('Backup Delete failed!');
            // })
            // ->onSuccess(function () {
            //     Log::info('Backup Delete succeeded!');
            // });


            // $schedule->command('db:backup')->everyMinute();

        //   $schedule->commands('backup:run')->cron('* * * * *');->everyMinute();->daily()->at('10:40')

		$schedule->call(function () {
            $data = new Cron_testing;
            $data->record = "testing";
            $data->save();
        })->everyMinute();

    }

   


    /**
     * Register the commands for the application.
     */
    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}
