<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('languages', function (Blueprint $table) {
	    $table->id();
            $table->string('name');
            $table->string('code')->unique(); // Example: 'en' for English
            $table->timestamps();
        });

        Schema::create('listing_languages', function (Blueprint $table) {
            $table->id();
            $table->integer('listing_id');
            $table->integer('language_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('languages');
    }
};
