{{-- show_verification_docs_field field --}}
@php
$field['value'] = old_empty_or_null($field['name'], '') ?? ($field['value'] ?? ($field['default'] ?? ''));
@endphp

@include('crud::fields.inc.wrapper_start')
<label>{!! $field['label'] !!}</label>
@include('crud::fields.inc.translatable_icon')

@if($entry->documents != "")
@php
$user_data = DB::table('users')->where('id', $entry->user_id)->first();
$docs = json_decode($entry->documents);
@endphp

<?php
if(empty($user_data)){
    abort(403, 'Unauthorized action.');
} ?>

<div>
    <h6><u>User Data</u></h6>
    <div><b>Name</b> : <?php echo $user_data->name; ?></div>
    <div style="margin-bottom: 20px;"><b>Email</b> : <?php echo $user_data->email; ?></div>

    <h6><u>Documents</u></h6>
    <?php 
    if(!empty($docs)){ 
        foreach($docs as $key=>$doc){
            $doc_url = url('/').'/uploads/verification-documents/lawyers/'.$entry->user_id.'/'.$key.'/'.$doc;
            echo '<div><b>'. ucwords(str_replace("_", " ", $key)) .'</b> : <a href="'.$doc_url.'" target="_blank">OPEN</a></div>';
        }
    } ?>
</div>
@endif

{{-- HINT --}}
@if (isset($field['hint']))
<p class="help-block">{!! $field['hint'] !!}</p>
@endif
@include('crud::fields.inc.wrapper_end')

{{-- CUSTOM CSS --}}
@push('crud_fields_styles')
{{-- How to load a CSS file? --}}
@basset('show_verification_docsFieldStyle.css')

{{-- How to add some CSS? --}}
@bassetBlock('backpack/crud/fields/show_verification_docs_field-style.css')
<style>
    .show_verification_docs_field_class {
        display: none;
    }
</style>
@endBassetBlock
@endpush

{{-- CUSTOM JS --}}
@push('crud_fields_scripts')
{{-- How to load a JS file? --}}
@basset('show_verification_docsFieldScript.js')

{{-- How to add some JS to the field? --}}
@bassetBlock('path/to/script.js')
<script>
    function bpFieldInitDummyFieldElement(element) {
            // this function will be called on pageload, because it's
            // present as data-init-function in the HTML above; the
            // element parameter here will be the jQuery wrapped
            // element where init function was defined
        console.log(element.val());
    }
</script>
@endBassetBlock
@endpush
