<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Sitemap\SitemapGenerator;
use Carbon\Carbon;
use Spatie\Sitemap\Sitemap;
use Spatie\Sitemap\Tags\Url;

class SitemapController extends Controller
{
    public function generate()
    {
        ini_set('max_execution_time', 50000);
        $path = public_path('sitemap.xml');
        $sitemap = Sitemap::create();

        // ALL PAGES
        $all_pages = DB::select('SELECT * FROM `pages`');
        if (!empty($all_pages)) {
            foreach ($all_pages as $apg) {
                $url_index = "no";
                if (isset($apg->extras) && $apg->extras != "" && $apg->extras != null) {
                    $meta = json_decode($apg->extras);
                    if (!empty($meta)) {
                        if (isset($meta->url_index)) {
                            $url_index = $meta->url_index;
                        }
                    }
                }

                if ($url_index == "yes") {
                    $sitemap->add(Url::create($apg->slug)
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        // ALL PRACTICE AREAS
        $all_pa = DB::select('SELECT * FROM `practice_areas`');
        if (!empty($all_pa)) {
            foreach ($all_pa as $apa) {
                $url_index = "no";
                if (isset($apa->url_index) && $apa->url_index != "") {
                    $url_index = $apa->url_index;
                }

                if ($url_index == "yes") {
                    $sitemap->add(Url::create("lawyers/pa/" . $apa->slug)
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        // ALL PRACTICE AREAS AND STATE
        $all_pa_state = DB::select('SELECT * FROM `practice_area_state_content`');
        if (!empty($all_pa_state)) {
            foreach ($all_pa_state as $apa_st) {
                $url_index = "no";
                if (isset($apa_st->url_index) && $apa_st->url_index != "") {
                    $url_index = $apa_st->url_index;
                }

                if ($url_index == "yes") {
                    $pa_data = DB::select('SELECT * FROM `practice_areas` WHERE id=' . $apa_st->practiceArea);
                    $parea = $pa_data[0]->slug;

                    $st_data = DB::select('SELECT * FROM `states` WHERE id=' . $apa_st->state);
                    $state = strtolower(str_replace(' ', '-', $st_data[0]->name));

                    $sitemap->add(Url::create("lawyers/pa/" . $parea . '/' . $state)
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        // ALL PRACTICE AREAS,STATE AND CITY
        $all_pa_state_city = DB::select('SELECT * FROM `practice_area_state_county_content`');
        if (!empty($all_pa_state_city)) {
            foreach ($all_pa_state_city as $apa_st_ct) {
                $url_index = "no";
                if (isset($apa_st_ct->url_index) && $apa_st_ct->url_index != "") {
                    $url_index = $apa_st_ct->url_index;
                }

                if ($url_index == "yes") {
                    $pa_data = DB::select('SELECT * FROM `practice_areas` WHERE id=' . $apa_st_ct->practiceArea);
                    $parea = $pa_data[0]->slug;

                    $st_data = DB::select('SELECT * FROM `states` WHERE id=' . $apa_st_ct->state);
                    $state = strtolower(str_replace(' ', '-', $st_data[0]->name));

                    $ct_data = DB::select('SELECT * FROM `counties` WHERE id=' . $apa_st_ct->county);
                    $city = strtolower(str_replace(' ', '-', $ct_data[0]->name));

                    $sitemap->add(Url::create("lawyers/pa/" . $parea . '/' . $state . '/' . $city)
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        // ALL STATES
        $all_st = DB::select('SELECT * FROM `states`');
        if (!empty($all_st)) {
            foreach ($all_st as $ast) {
                $url_index = "no";
                if (isset($ast->url_index) && $ast->url_index != "") {
                    $url_index = $ast->url_index;
                }

                if ($url_index == "yes") {
                    $state = strtolower(str_replace(' ', '-', $ast->name));
                    $sitemap->add(Url::create("lawyers/loc/" . $state)
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        // ALL STATES/CITY
        $all_st_ct = DB::select('SELECT * FROM `counties` WHERE `type`="City"');
        if (!empty($all_st_ct)) {
            foreach ($all_st_ct as $ast_ct) {
                $url_index = "no";
                $c_url_index = "no";
                $s_url_index = "no";

                if (isset($ast_ct->url_index) && $ast_ct->url_index != "") {
                    $c_url_index = $ast_ct->url_index;
                }

                $state_data = DB::select('SELECT * FROM `states` WHERE `name`= "' . $ast_ct->state_name . '"');
                if (!empty($state_data)) {
                    $s_url_index = $state_data[0]->url_index;
                }

                if ($c_url_index == $s_url_index) {
                    $url_index = $c_url_index;
                }

                if ($url_index == "yes") {
                    $state = strtolower(str_replace(' ', '-', $ast_ct->state_name));
                    $city = strtolower(str_replace(' ', '-', $ast_ct->name));
                    $sitemap->add(Url::create("lawyers/loc/" . $state . '/' . $city)
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        // ALL STATES/COUNTY
        $all_st_ct = DB::select('SELECT * FROM `counties` WHERE `type`="County"');
        if (!empty($all_st_ct)) {
            foreach ($all_st_ct as $ast_ct) {
                $url_index = "no";
                $c_url_index = "no";
                $s_url_index = "no";

                if (isset($ast_ct->url_index) && $ast_ct->url_index != "") {
                    $c_url_index = $ast_ct->url_index;
                }

                $state_data = DB::select('SELECT * FROM `states` WHERE `name`= "' . $ast_ct->state_name . '"');
                if (!empty($state_data)) {
                    $s_url_index = $state_data[0]->url_index;
                }

                if ($c_url_index == $s_url_index) {
                    $url_index = $c_url_index;
                }

                if ($url_index == "yes") {
                    $state = strtolower(str_replace(' ', '-', $ast_ct->state_name));
                    $city = strtolower(str_replace(' ', '-', $ast_ct->name));
                    $sitemap->add(Url::create("lawyers/loc/" . $state . '/' . $city.'-county')
                        ->setLastModificationDate(Carbon::yesterday())
                        ->setChangeFrequency(Url::CHANGE_FREQUENCY_YEARLY)
                        ->setPriority(0.1));
                }
            }
        }

        $sitemap->writeToFile($path);
    }

    public function view($slug)
    {
        // GET ALL PRACTICE AREAS
        $all_pa = DB::select('SELECT * FROM `practice_areas` WHERE `url_index` = "yes"');
        $pa_links = array();
        if (!empty($all_pa)) {
            foreach ($all_pa as $apa) {
                $url_index = "no";
                if (isset($apa->url_index) && $apa->url_index != "") {
                    $url_index = $apa->url_index;
                }

                if ($url_index == "yes") {
                    array_push($pa_links, "sitemap-" . $apa->slug);
                }
            }
        }

        // RETURN SITEMAP DATA
        if ($slug == "sitemap") {

            // $links = array("sitemap-practice-areas", "sitemap-locations", "sitemap-lawyers", "sitemap-pages", "sitemap-resources");
            // $links = array("sitemap-practice-areas", "sitemap-locations", "sitemap-lawyers", "sitemap-pages");
            $links = array("sitemap-practice-areas", "sitemap-locations", "sitemap-pages");

            $contents = view('sitemap/all')->with('links', $links);

            if(!empty($links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } elseif ($slug == "sitemap-practice-areas") {

            $contents = view('sitemap/all')->with('links', $pa_links);

            if(!empty($pa_links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } elseif ($slug == "sitemap-locations") {
            $loc_links = array();

            // ALL STATES
            $all_st = DB::select('SELECT * FROM `states` WHERE `url_index` = "yes"');
            if (!empty($all_st)) {
                foreach ($all_st as $ast) {
                    $url_index = "no";
                    if (isset($ast->url_index) && $ast->url_index != "") {
                        $url_index = $ast->url_index;
                    }

                    if ($url_index == "yes") {
                        $state = strtolower(str_replace(' ', '-', $ast->name));
                        $state = str_replace(".", "", $state);

                        array_push($loc_links, url('/lawyers/loc/' . $state));
                    }
                }
            }

            // ALL STATES/CITY || COUNTY
            $all_st_ct = DB::select('SELECT * FROM `counties` WHERE `url_index` = "yes"');
            if (!empty($all_st_ct)) {
                foreach ($all_st_ct as $ast_ct) {
                    $url_index = "no";
                    $c_url_index = "no";
                    $s_url_index = "no";

                    if (isset($ast_ct->url_index) && $ast_ct->url_index != "") {
                        $c_url_index = $ast_ct->url_index;
                    }

                    $state_data = DB::select('SELECT * FROM `states` WHERE `name`= "' . $ast_ct->state_name . '"');
                    if (!empty($state_data)) {
                        $s_url_index = $state_data[0]->url_index;
                    }

                    if ($c_url_index == $s_url_index) {
                        $url_index = $c_url_index;
                    }

                    if ($url_index == "yes") {
                        $state = strtolower(str_replace(' ', '-', $ast_ct->state_name));
                        $state = str_replace(".", "", $state);
                        $city = strtolower(str_replace(' ', '-', $ast_ct->name));
                        $city = str_replace(".", "", $city);

                        if ($ast_ct->type == "City") {
                            array_push($loc_links, url('/lawyers/loc/' . $state . '/' . $city));
                        } else {
                            array_push($loc_links, url('/lawyers/loc/' . $state . '/' . $city . '-county'));
                        }
                    }
                }
            }

            $contents = view('sitemap/single')->with('links', $loc_links);

            if(!empty($loc_links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } elseif ($slug == "sitemap-lawyers") {
            $lawyer_links = array();

            // GET ALL LAWYERS
            $all_lawyers = DB::select('SELECT * FROM `listings` WHERE `url_index` = "yes"');
            if (!empty($all_lawyers)) {
                foreach ($all_lawyers as $lawyer) {
                    $url_index = "no";
                    if (isset($lawyer->url_index) && $lawyer->url_index != "") {
                        $url_index = $lawyer->url_index;
                    }

                    if ($url_index == "yes") {
                        $l_fname = strtolower($lawyer->first_name . '-' . ($lawyer->middle_name ? $lawyer->middle_name . '-' : '') . $lawyer->last_name);
                        $l_fname = str_replace('.', '-', $l_fname);
                        $l_fname = str_replace(',', '-', $l_fname);
                        $l_fname = str_replace('`', '-', $l_fname);
                        $l_fname = str_replace("'", '-', $l_fname);
                        $l_fname = str_replace(' ', '-', $l_fname);
                        $l_fname = str_replace('(', '-', $l_fname);
                        $l_fname = str_replace(')', '-', $l_fname);
                        $l_fname = str_replace('--', '-', $l_fname) . '-' . $lawyer->id;
                        $l_fname = str_replace('--', '-', $l_fname);

                        array_push($lawyer_links, url('/lawyer/' . $l_fname));
                    }
                }
            }

            $contents = view('sitemap/single')->with('links', $lawyer_links);

            if(!empty($lawyer_links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } elseif ($slug == "sitemap-pages") {
            $pages_links = array();

            // ALL PAGES
            $all_pages = DB::select('SELECT * FROM `pages`');
            if (!empty($all_pages)) {
                foreach ($all_pages as $apg) {
                    $url_index = "no";
                    if (isset($apg->extras) && $apg->extras != "" && $apg->extras != null) {
                        $meta = json_decode($apg->extras);
                        if (!empty($meta)) {
                            if (isset($meta->url_index)) {
                                $url_index = $meta->url_index;
                            }
                        }
                    }

                    if ($url_index == "yes") {
                        if ($apg->slug != "/") {
                            array_push($pages_links, url('/' . $apg->slug));
                        } else {
                            array_push($pages_links, url('/'));
                        }
                    }
                }
            }

            $contents = view('sitemap/single')->with('links', $pages_links);

            if(!empty($pages_links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } elseif ($slug == "sitemap-resources") {
            $resources_links = array();

            $contents = view('sitemap/single')->with('links', $resources_links);

            if(!empty($resources_links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } elseif (in_array($slug, $pa_links) !== false) {
            $links = array();
            $pa_slug = str_replace("sitemap-", "", $slug);
            $url_index = "no";
            $pa_data = DB::select('SELECT * FROM `practice_areas` WHERE slug="' . $pa_slug . '" AND `url_index` = "yes"');
            if (empty($pa_data)) {
                abort("404");
            }

            // PA LINK
            if ($pa_data[0]->url_index == "yes") {
                array_push($links, url('/lawyers/pa/' . $pa_data[0]->slug));
            }

            // ALL PRACTICE AREAS AND STATE
            $all_pa_state = DB::select('SELECT * FROM `practice_area_state_content` WHERE  `url_index` = "yes" AND `practiceArea` = ' . $pa_data[0]->id);
            if (!empty($all_pa_state)) {
                foreach ($all_pa_state as $apa_st) {
                    $url_index = "no";
                    if (isset($apa_st->url_index) && $apa_st->url_index != "") {
                        $url_index = $apa_st->url_index;
                    }

                    if ($url_index == "yes") {
                        $pa_data = DB::select('SELECT * FROM `practice_areas` WHERE id=' . $apa_st->practiceArea);
                        $parea = $pa_data[0]->slug;

                        $st_data = DB::select('SELECT * FROM `states` WHERE id=' . $apa_st->state);
                        $state = strtolower(str_replace(' ', '-', $st_data[0]->name));

                        array_push($links, url('/lawyers/pa/' . $parea . '/' . $state));
                    }
                }
            }

            // ALL PRACTICE AREAS,STATE AND CITY
            $all_pa_state_city = DB::select('SELECT * FROM `practice_area_state_city_content` WHERE `url_index` = "yes" AND `practiceArea` = ' . $pa_data[0]->id);
            if (!empty($all_pa_state_city)) {
                foreach ($all_pa_state_city as $apa_st_ct) {
                    $url_index = "yes";
                    if (isset($apa_st_ct->url_index) && $apa_st_ct->url_index != "") {
                        $url_index = $apa_st_ct->url_index;
                    }

                    if ($url_index == "yes") {
                        $pa_data = DB::select('SELECT * FROM `practice_areas` WHERE id=' . $apa_st_ct->practiceArea);
                        $parea = $pa_data[0]->slug;

                        $st_data = DB::select('SELECT * FROM `states` WHERE id=' . $apa_st_ct->state);
                        $state = strtolower(str_replace(' ', '-', $st_data[0]->name));

                        $ct_data = DB::select('SELECT * FROM `counties` WHERE id=' . $apa_st_ct->county);
                        $city = strtolower(str_replace(' ', '-', $ct_data[0]->name));
                        $city = str_replace(".", "", $city);

                        array_push($links, url('/lawyers/pa/' . $parea . '/' . $state . '/' . $city));
                    }
                }
            }

            // ALL PRACTICE AREAS,STATE AND County
            $all_pa_state_city = DB::select('SELECT * FROM `practice_area_state_county_content` WHERE `url_index` = "yes" AND `practiceArea` = ' . $pa_data[0]->id);
            if (!empty($all_pa_state_city)) {
                foreach ($all_pa_state_city as $apa_st_ct) {
                    $url_index = "yes";
                    if (isset($apa_st_ct->url_index) && $apa_st_ct->url_index != "") {
                        $url_index = $apa_st_ct->url_index;
                    }

                    if ($url_index == "yes") {
                        $pa_data = DB::select('SELECT * FROM `practice_areas` WHERE id=' . $apa_st_ct->practiceArea);
                        $parea = $pa_data[0]->slug;

                        $st_data = DB::select('SELECT * FROM `states` WHERE id=' . $apa_st_ct->state);
                        $state = strtolower(str_replace(' ', '-', $st_data[0]->name));

                        $ct_data = DB::select('SELECT * FROM `counties` WHERE id=' . $apa_st_ct->county);
                        $city = strtolower(str_replace(' ', '-', $ct_data[0]->name));
                        $city = str_replace(".", "", $city);

                        array_push($links, url('/lawyers/pa/' . $parea . '/' . $state . '/' . $city . '-county'));
                    }
                }
            }

            $contents = view('sitemap/single')->with('links', $links);

            if(!empty($links)){
                return response($contents)->header('Content-Type', 'text/xml; charset=UTF-8');
            }

        } else {

            abort("404");

        }
    }
}
