<?php

namespace App\Models;

use Backpack\CRUD\app\Models\Traits\HasIdentifiableAttribute;
use Backpack\CRUD\app\Models\Traits\CrudTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Backpack\CRUD\app\Models\Traits\SpatieTranslatable\Sluggable;
use Backpack\CRUD\app\Models\Traits\SpatieTranslatable\SluggableScopeHelpers;
use Backpack\CRUD\app\Models\Traits\SpatieTranslatable\HasTranslations;
//use Spatie\Translatable\HasTranslations;
    
class Listing extends Model
{
    use CrudTrait;
    use HasFactory;
    use HasTranslations;

    /*
    |--------------------------------------------------------------------------
    | GLOBAL VARIABLES
    |--------------------------------------------------------------------------
    */

    protected $table = 'listings';
    // protected $primaryKey = 'id';
    // public $timestamps = false;
    protected $guarded = ['id'];
    protected $fillable = ['first_name', 'middle_name', 'last_name', 'url', 'email', 'phone', 'description', 'firm_id', 'user_id', 'languages', 'featured','url_index'];
    // protected $hidden = [];
    public $translatable = ['description'];
    protected $appends = ['title'];

    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */

    public function getTitleAttribute() {
        return $this->first_name . ' ' . $this->last_name;
    }

    public function getfrontlink()
    {
        $l_fname = strtolower($this->first_name . '-' . ($this->middle_name ? $this->middle_name . '-' : '') . $this->last_name);
        return '<a href="' . url('lawyer/'.str_replace(' ', '-', $l_fname) . '-' . $this->id) . '" target="_blank">View</a>';
    }

    /*
    |--------------------------------------------------------------------------
    | FUNCTIONS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | RELATIONS
    |--------------------------------------------------------------------------
    */
    public function firm()
    {
        return $this->belongsTo('App\Models\Firm');
    }

    public function user() 
    {
        return $this->belongsTo('App\Models\User');
    }

    public function practiceAreas()
    {
        return $this->belongsToMany('App\Models\PracticeArea', 'listing_practice_area');
    }

    public function districts()
    {
        return $this->belongsToMany('App\Models\District', 'listing_jurisdictions');
    }

    public function language()
    {
        return $this->belongsToMany('App\Models\Language', 'listing_languages');
    }


    public function practice_area()
    {
        return $this->belongsTo('App\Models\PracticeArea');
    }


    public function district()
    {
        return $this->belongsTo('App\Models\District');
    }


    public function jurisdictions()
    {
        return $this->belongsTo('App\Models\District');
    }
    public function address()
    {
        return $this->hasMany(\App\Models\Address::class);
    }

    public function professional_experience()
    {
        return $this->hasMany(\App\Models\ProfessionalExperience::class);
    }
    public function professional_association()
    {
        return $this->hasMany(\App\Models\ProfessionalAssociation::class);
    }

    public function publication()
    {
        return $this->hasMany(\App\Models\Publication::class);
    }

    public function award()
    {
        return $this->hasMany(\App\Models\Award::class);
    }

    public function engagement()
    {
        return $this->hasMany(\App\Models\Engagement::class);
    }

    public function link()
    {
        return $this->hasMany(\App\Models\Link::class);
    }

    public function social_network()
    {
        return $this->hasMany(\App\Models\SocialNetwork::class);
    }

    public function education()
    {
        return $this->hasMany(\App\Models\Education::class);
    }

    public function fee()
    {
        return $this->belongsToMany(\App\Models\Fee::class, 'listing_fees')->withPivot('description');
    }

    public function jurisdiction()
    {
        return $this->hasMany(\App\Models\Jurisdiction::class);
    }

    public function fees()
    {
        return $this->belongsToMany(\App\Models\Fee::class, 'listing_fees');
    }

    /*
    |--------------------------------------------------------------------------
    | SCOPES
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | ACCESSORS
    |--------------------------------------------------------------------------
    */

    /*
    |--------------------------------------------------------------------------
    | MUTATORS
    |--------------------------------------------------------------------------
    */
}
