@include('header')

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/glossary-of-legal-terms.css">

<script src="{{ url('/') }}/js/glossary-of-legal-terms.js"></script>

<script>

document.addEventListener('DOMContentLoaded', function () {
    const glossaryNavLinks = document.querySelectorAll('.glossary-nav a');

    glossaryNavLinks.forEach(link => {
        link.addEventListener('click', function() {
            glossaryNavLinks.forEach(l => l.classList.remove('active'));
            this.classList.add('active');
        });
    });
});

</script>

<!-- glossary page banner section html start -->
<section class="glossary-banner-wapper">
	<div class="container w-1280">
		<div class="glossary-banner-card">
			<h1>Glossary of Legal Terms</h1>
			<p>Understand the meaning of intricate legal terms with our exhaustive guide. Perfect for both budding law students and seasoned attorneys. </p>
			@include('templates/top_search_glossary')
		</div>
	</div>
</section>

<!-- Glossary index section html start -->

@if(!empty($glossaries))

	<section class="glossary-section-wapper">
		<div class="container w-1280">
			<div class="glossary-nav-wapper">
				<div class="glossary-nav">
				    @foreach (range('A', 'Z') as $letter)
					@if(isset($glossaries[$letter]) && count($glossaries[$letter]) > 0)
					        <a href="#{{ $letter }}" class="{{ request()->get('letter') == $letter ? 'active' : '' }}">{{ $letter }}</a>
					@else
						<a href="" class="">{{ $letter }}</a>
					@endif
				    @endforeach
					<a href="#top">Top</a>
				</div>
			</div>
		</div>
	</section>

<section class="glossary-content-wapper">
    <div class="container w-1280">
        @foreach($glossaries as $letter => $entries)
            <div class="glossary-content-card" id="{{ $letter }}">
                <h3>{{ $letter }}</h3>
                @foreach($entries as $entry)
                    <p><b>{{ $entry->name }}</b> - {{ $entry->definition }}</p>
                @endforeach
            </div>
        @endforeach
    </div>
</section>

@endif


@include('footer')
