function bpFieldInitIconPickerElement(element) {
    var $iconset = element.attr('data-iconset');
    var $iconButton = element.siblings('button[role=icon-selector]');
    var $icon = element.attr('value');

    // we explicit init the iconpicker on the button element.
    // this way we can init the iconpicker in InlineCreate as in future provide aditional configurations.
        $($iconButton).iconpicker({
            iconset: $iconset,
            icon: $icon
        });

        element.siblings('button[role=icon-selector]').on('change', function(e) {
            $(this).siblings('input[type=hidden]').val(e.icon).trigger('change');
        });

        element.on('CrudField:enable', function(e) {
            $iconButton.removeAttr('disabled');
        });

        element.on('CrudField:disable', function(e) {
            $iconButton.attr('disabled', 'disabled');
        });
}

        