<?php
namespace App\Http\Controllers;

use Backpack\PageManager\app\Models\Page;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\PracticeArea;
use App\Models\Listing;
use App\Models\listing_reviews;
use App\Models\Address;
use App\Models\State;
use App\Models\County;
use App\Models\PracticeAreaAndStateContent;
use App\Mail\LawyerContactEmail;

class WriterController extends Controller
{

    // /lawyers
   public function index(){
        return "Hello";
   }

    // /lawyer/ id
    public function profile($slug)
    {
        $slug = explode('-', $slug);
        $slug = end($slug);

        $similar = array();

        $lawyer = Listing::with('firm')->with('education')->with('fee')->with('professional_experience')->with('jurisdiction')->with('education')->with('award')->with('language')->with('practiceAreas')->find($slug);

        if (!$lawyer) {
            return abort(404);
        }

        $reviews = DB::table('listing_reviews')->where('listing_id', $slug)->where('approved', 'yes')->get();
        $avg = 0;
        if ($reviews->count() > 0) {
            $avg = ceil($reviews->sum('rating') / $reviews->count());
        }

        if ($lawyer->jurisdiction && $lawyer->jurisdiction->isNotEmpty()) {
            if ($lawyer->jurisdiction->first()->since != "") {
                $lawyer->experience_years = date("Y") - $lawyer->jurisdiction->first()->since;
            }
        }

        // SET META
        $city = "";
        $p_area = "";
        $state = "";
        if ($lawyer->address && $lawyer->address->isNotEmpty()) {
            $address = $lawyer->address->first();
        }
        if ($lawyer->practiceAreas && $lawyer->practiceAreas->isNotEmpty()) {
            $p_area = $lawyer->practiceAreas->first();
        }
        if (!empty($address)) {
            $city = $address->city;
            $state = $address->state;
        }
        if (!empty($p_area)) {
            $p_area = $p_area->name;
        }

        $l_name = ($lawyer->prefix ? $lawyer->prefix . '.' : '') . ' ' . $lawyer->first_name . ' ' . ($lawyer->middle_name ? $lawyer->middle_name : '') . ' ' . $lawyer->last_name;

        $title = $l_name . ", Lawyer in " . $city . ", " . $state . " | Legal.com";
        $meta = array(
            "meta_title" => $title,
            "meta_description" => "Meet " . $l_name . ", an experienced attorney in " . $city . ", " . $state . ". Explore their background, services, and contact details here on Legal.com."
        );
        $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $lawyer->url_index];

        // Similar data
        if ($lawyer->featured != 1) {
            $similar = Listing::with('firm')->with('education')->with('fee')->with('professional_experience')->with('jurisdiction')->with('award')->with('language')->with('practiceAreas')->where('featured', 1)->get();
        }

        return view('lawyers/lawyers_profile_page', ['page' => $page, 'lawyer' => $lawyer, 'p_area' => $p_area, 'state' => $state, 'reviews' => $reviews, 'avg' => $avg, 'total_reviews' => $reviews->count(), 'similar' => $similar])->withShortcodes();
    }

   

    // pagination - /lawyers_paginate
    // public function ic_lawyers_paginate(Request $request)
    // {   
    //     $p_area = $request->p_area;
    //     $state = $request->state;
    //     $city = $request->city;

    //     $practiceArea = PracticeArea::where('name', $p_area)->first();

    //     if($city != ""){
    //         $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
    //             $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
    //         })->whereHas('address', function ($query) use ($state) {
    //             $query->where('state', $state);
    //         })->whereHas('address', function ($query) use ($city) {
    //             $query->where('city', $city);
    //         })->paginate(6);
    //     }else{
    //         $lawyers = Listing::with('education')->with('practiceAreas')->with('address')->whereHas('practiceAreas', function ($query) use ($practiceArea) {
    //             $query->where('listing_practice_area.practice_area_id', $practiceArea->id);
    //         })->whereHas('address', function ($query) use ($state) {
    //             $query->where('state', $state);
    //         })->paginate(6);
    //     }

    //     $s_arr = array('p_area','state','lawyers');
    //     return view('lawyers/lawyers_pagination', compact($s_arr))->render();
    // }
}
