<?php
namespace App\Http\Controllers;

use Illuminate\Support\Str; 
use Backpack\PageManager\app\Models\Page;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Mail;
use App\Mail\NewJobApplicationEmail;
use App\Models\Position;

use Log;

class JobController extends Controller
{
	public function careers_index()
	{
		$title = "Careers | Legal.com";
		$meta = array(
                	"meta_title" => $title,
                        "meta_description" => "Careers on Legal.com."
                );
                $page = (object) ['extras' => $meta, "title" => $title];
		$jobs = Position::all();
                return view('jobs/index', ['page' => $page, 'jobs' => $jobs])->withShortcodes();

	}

	public function application_form($job_id)
	{	
		if($job_id != ""){
			$title = "Job Apply | Legal.com";
			$meta = array(
				"meta_title" => $title,
				"meta_description" => "Job Apply on Legal.com."
			);
			$page = (object) ['extras' => $meta, "title" => $title];

			return view('jobs/application_form', ['page' => $page, 'job_id' => $job_id])->withShortcodes();
		}else{
			abort(404);
		}
	}

	public function apply_job(Request $request){
		$job_id = $request->job_id;
		$db_arr = array();

		if($job_id != "" && !empty($_FILES)){
			$path = 'uploads/job-documents/' . $job_id;

			foreach($_FILES as $fk=>$files){
				$file = $request->file($fk);
				$ky = strtolower($fk);

				$filename = time() . '_'. $ky . '_' . $file->getClientOriginalName();

				$location = $path.'/';
				$file->move($location, $filename);

				$db_arr[$fk] = $filename;
			}

			// add Data in database
			$id = DB::table('job_applications')->insertGetId([
				'job_id' => $job_id,
				'full_name' => $request->full_name,
				'email' => $request->email,
				'resume' => $db_arr['Resume'],
				'motivational_letter' => $db_arr['motivational-letter'],
				'created_at' => date('Y-m-d H:i:s'),
				'updated_at' => date('Y-m-d H:i:s'),
			]);

			$job_email = DB::select('SELECT * FROM `settings` WHERE `key`="new_job_email"');
			if (!empty($job_email)) {
				Mail::to($job_email[0]->value)->send(new NewJobApplicationEmail($request,$id));
			}

			return json_encode(array('e_code'=> 0,'success'=> 'Application sent successfully.','error'=>''));
		}else{
			return json_encode(array('e_code'=>'wrong','error'=> 'Something Went Wrong'));
		}
	}
}
