<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\PracticeAreaRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class PracticeAreaCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class PracticeAreaCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\PracticeArea::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/practice-area');
        CRUD::setEntityNameStrings('practice area', 'practice areas');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {

        CRUD::column('name');
        CRUD::column('slug');

        CRUD::column('parent_id')->label('Parent')
        ->type('select')
        ->name('parent_id')
        ->entity('parent')
        ->attribute('name')
        ->model('App\Models\PracticeArea');

        CRUD::column([
            'name'  => 'view_link',
            'label' => 'View Front',
            'type'  => 'model_function',
            'function_name' => 'getfrontlink', 
            'limit' => 10000,
            'escaped' => false,
        ]);

        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(PracticeAreaRequest::class);

        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]);
        CRUD::field('name')->type('text');
        
        CRUD::field('slug')->type('text');


//	CRUD::field('parent_id')->label('Parent')->type('select2')->name('parent_id')->entity('practice_area');
/*
	CRUD::field([   // select_grouped
	    'label'     => 'Parent',
	    'type'      => 'select_grouped', //https://github.com/Laravel-Backpack/CRUD/issues/502
	    'name'      => 'parent_id',
	    'entity'    => 'practice_area',
	    'attribute' => 'name',
	    'group_by'  => 'parent', // the relationship to entity you want to use for grouping
	    'group_by_attribute' => 'name', // the attribute on related model, that you want shown
	    'group_by_relationship_back' => 'practice_area', // relationship from related model back to this model
	]);
*/
    CRUD::field([
        'label'     => 'Parent',
        'type'      => 'select_grouped',
        'name'      => 'parent_id',
        'entity'    => 'parent',
        'attribute' => 'name',
        'group_by'  => 'parent',
        'group_by_attribute' => 'name',
        'group_by_relationship_back' => 'children',
    ]);

    CRUD::field([
        'name' => 'short_content',
        'type' => 'summernote',
        'label' => 'Short Content',
        'fake' => true,
        'store_in' => 'extras',
    ]);

    CRUD::field([
        'name' => 'h2_after_short_content',
        'type' => 'text',
        'label' => 'H2 After Short Content',
        'fake' => true,
        'store_in' => 'extras',
    ]);

    CRUD::field('lawyer_list_title')->type('text');

    CRUD::field('description')->type('summernote');

    CRUD::field([
        'name' => 'faqs_title',
        'type' => 'text',
        'label' => 'FAQs Title',
        'fake' => true,
        'store_in' => 'extras',
    ]);
    CRUD::field([
        'tab'           => 'Frequently Asked Questions',
        'label'         => 'FAQs',
        'type'          => "relationship",
        'model'         => 'App\Models\PracticeAreaFaq',
        'pivot'         => true,
        'entity'        => 'faqs',
        'name'          => 'faqs',
        'subfields'   => [
            [
                'name' => 'title',
                'label' => 'Title',
                'type' => 'text',
                'wrapper' => [
                    'class' => 'form-group col-md-12',
                ],
            ],

            [
                'name' => 'answer',
                'label' => 'Answer',
                'type' => 'textarea',
                'wrapper' => [
                    'class' => 'form-group col-md-12',
                ],
            ],
        ],
    ]);


        //CRUD::setFromDb(); // set fields from db columns.


        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
