<?php
namespace App\Http\Controllers;

use Backpack\PageManager\app\Models\Page;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Query\JoinClause;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Mail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

use App\Models\Blogs;
use App\Models\BlogCategories;
use App\Models\User;

class BlogController extends Controller
{

    // /blog_archive
    public function blog_archive()
    {
        // META
        $page = Page::findBySlug('edu');

        // GET Blogs
        $blogs = Blogs::with('written')->
        whereHas('written', function ($query) use ($page) {
            $query->where('blogs.category', '!=', '');
        })->orderby('created_at', 'DESC')->paginate(9);

        return view('blogs/blog_archive', ['page' => $page, 'blogs' => $blogs])->withShortcodes();
        // return view('test');
    }

    // /blog_author
    public function blog_author($author_slug)
    {   
        $author = User::where('slug', $author_slug)->first();
        
        if (empty($author)) {
            return abort(404);
        }

        // META
        if ($author->id != "") {
            // SET META
            $content = DB::table('users')->where('id', $author->id)->first();

            $title = "$content->name | Legal.com";
            $m_des = $content->name;

            $meta = array(
                "meta_title" => $title,
                "meta_description" => $m_des
            );
            $page = (object) ['extras' => $meta, "title" => $title];

            if (isset($content->extras) && !empty($content->extras)) {

                $cdata = json_decode($content->extras);

                if (!empty($cdata)) {
                    if ($cdata->meta_title != "") {
                        $title = $cdata->meta_title;
                    }
                    if ($cdata->meta_description != "") {
                        $m_des = $cdata->meta_description;
                    }

                    $meta = array(
                        "meta_title" => $title,
                        "meta_description" => $m_des
                    );
                    $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $content->url_index];
                }
            }
        }

        // GET Blogs
        $blogs = Blogs::with('written')->
        whereHas('written', function ($query) use ($author) {
            $query->where('blogs.written_by', $author->id);
            $query->where('blogs.category', '!=', '');
        })->orderby('created_at', 'DESC')->paginate(9);

        return view('blogs/blog_author', ['page' => $page, 'blogs' => $blogs, 'author_data' => $content])->withShortcodes();
    }

    // /blog_single
    public function blog_single_p_c($parent_cat, $child_cat, $post_slug){
        $parent_cat_data = BlogCategories::where('slug', $parent_cat)->first();
        $child_cat_data = BlogCategories::where('slug', $child_cat)->first();
        $blog_data = Blogs::with('written')->with('fact_check')->where('slug', $post_slug)->first();
        
        if (empty($blog_data) || empty($parent_cat_data) || empty($child_cat_data)) {
            return abort(404);
        }

        // META
        if ($blog_data->id != "") {
            $content = DB::table('blogs')->where('id', $blog_data->id)->first();

            $title = "$content->name | Legal.com";
            $m_des = $content->name;

            $meta = array( "meta_title" => $title, "meta_description" => $m_des);
            $page = (object) ['extras' => $meta, "title" => $title];

            if (isset($content->extras) && !empty($content->extras)) {

                $cdata = json_decode($content->extras);

                if (!empty($cdata)) {
                    if ($cdata->meta_title != "") {
                        $title = $cdata->meta_title;
                    }
                    if ($cdata->meta_description != "") {
                        $m_des = $cdata->meta_description;
                    }

                    $meta = array( "meta_title" => $title, "meta_description" => $m_des );
                    $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $content->url_index];
                }
            }
        }

        return view('blogs/blog_single', ['page' => $page, 'blog_data' => $blog_data])->withShortcodes();
    }

    public function blog_single_p($parent_cat, $post_slug){
        $parent_cat_data = BlogCategories::where('slug', $parent_cat)->first();
        $blog_data = Blogs::with('written')->with('fact_check')->where('slug', $post_slug)->first();

        if (empty($blog_data) || empty($parent_cat_data)) {
            return abort(404);
        }

        // META
        if ($blog_data->id != "") {
            $content = DB::table('blogs')->where('id', $blog_data->id)->first();

            $title = "$content->name | Legal.com";
            $m_des = $content->name;

            $meta = array( "meta_title" => $title, "meta_description" => $m_des );
            $page = (object) ['extras' => $meta, "title" => $title];

            if (isset($content->extras) && !empty($content->extras)) {

                $cdata = json_decode($content->extras);

                if (!empty($cdata)) {
                    if ($cdata->meta_title != "") {
                        $title = $cdata->meta_title;
                    }
                    if ($cdata->meta_description != "") {
                        $m_des = $cdata->meta_description;
                    }

                    $meta = array( "meta_title" => $title, "meta_description" => $m_des );
                    $page = (object) ['extras' => $meta, "title" => $title, "url_index" => $content->url_index];
                }
            }
        }

        return view('blogs/blog_single', ['page' => $page, 'blog_data' => $blog_data])->withShortcodes();
    }
}
