<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\PracticeArea_State_CountyContentRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class PracticeAreaStateCountyContentCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class PracticeAreaStateCountyContentCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\PracticeAreaStateCountyContent::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/practice-area-state-county-content');
        CRUD::setEntityNameStrings('practice area-state-county content', 'practice area-state-county contents');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        CRUD::column('practiceArea')->label('Practice Area')->type('select')->name('practiceArea')->entity('practiceAreas')->attribute('name')->model('App\Models\PracticeArea');

        CRUD::column('state')->label('State')->type('select')->name('state')->entity('states')->attribute('name')->model('App\Models\State');

        CRUD::column('county')->label('County')->type('select')->name('county')->entity('counties')->attribute('name')->model('App\Models\County');
        
        CRUD::column([
            'name'  => 'view_link',
            'label' => 'View Front',
            'type'  => 'model_function',
            'function_name' => 'getfrontlink', 
            'limit' => 10000,
            'escaped' => false,
        ]);
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(PracticeArea_State_CountyContentRequest::class);
        // CRUD::setFromDb();

        // METAS
        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_title',
            'label'    => "Meta Title",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_description',
            'label'    => "Meta Description",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]);
        CRUD::field([
            'name'     => 'meta_keywords',
            'label'    => "Meta Keywords",
            'fake'     => true,
            'store_in' => 'extras',
            'tab' => 'Meta',
        ]); 

        // IDs
        CRUD::field([
            'label'     => "Practice Area",
            'type'      => 'select2',
            'name'      => 'practiceArea',
            'entity'    => 'practiceAreas',
            'model'     => "App\Models\PracticeArea",
            'attribute' => 'name',
            'tab' => 'Information',
        ]);

        CRUD::field([
            'label'     => "State",
            'type'      => 'select2',
            'name'      => 'state',
            'entity'    => 'states',
            'model'     => "App\Models\State",
            'attribute' => 'name',
            'tab' => 'Information',
        ]);

        CRUD::field([
            'label'     => "County",
            'type'      => 'select2_from_ajax',
            'name'      => 'county',
            'entity'    => 'counties',
            'attribute' => 'name',
            'method'    => 'POST',
            'dependencies' => ['state'],
            'data_source' => url("api/county"),
            'placeholder' => "Select a county",
            'include_all_form_fields' => true,
            'tab' => 'Information',
        ]);

        // Content & Faqs
        $this->crud->addField([
            'name' => 'short_content',
            'type' => 'summernote',
            'label' => 'Short Content',
            'store_in' => 'short_content',
            'tab' => 'Information',
        ]);

        $this->crud->addField([
            'name' => 'h2_after_s_c',
            'type' => 'text',
            'label' => 'H2 After Short Content',
            'store_in' => 'h2_after_s_c',
            'tab' => 'Information',
        ]);

        $this->crud->addField([
            'name' => 'full_content',
            'type' => 'summernote',
            'label' => 'Full Content',
            'store_in' => 'full_content',
            'tab' => 'Information',
        ]);

        $this->crud->addField([
            'name' => 'faqs_title',
            'type' => 'text',
            'label' => 'Faq Title',
            'fake' => true,
            'store_in' => 'extras',
            'tab' => 'Information',
        ]);

        $this->crud->addField([
            'name' => 'faqs',
            'label' => 'Faqs',
            'type' => 'repeatable',
            'fake' => true,
            'store_in' => 'extras',
            'tab' => 'Information',
            'fields' => [
                [
                    'name' => 'faq_title',
                    'type' => 'text',
                    'label' => 'FAQ Title',
                    'fake' => true,
                    'wrapper' => [ 'class' => 'form-group col-md-4', ],
                ],
                [
                    'name' => 'faq_description',
                    'type' => 'textarea',
                    'label' => 'FAQ Description',
                    'fake' => true,
                    'wrapper' => [ 'class' => 'form-group col-md-8', ],
                ],
            ],

            // optional
            'new_item_label' => 'Add FAQ',
            'init_rows' => 1,
            'max_rows' => 10,
        ]);
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
