$(document).ready(function(){
	// #search
	if(window.location.hash) {
		var hash = window.location.hash.substring(1).toLowerCase(); 
		$(".glossary-content-wapper p b").each(function(){
			var find = $(this).text().toLowerCase().replace(/\s+/g, '-');
			if(find == hash){
				$('body,html').animate({
					scrollTop: jQuery(this).offset().top - 100
				}, 1000 );
			}
		});
	}
	// #endsearch

	var scrollLink = jQuery('.glossary-nav a');
	scrollLink.each(function () {
		var targetId = jQuery(this).attr("href");
		if(targetId != "#top"){
			if (jQuery(targetId).length === 0) {
				jQuery(this).remove();
			}
		}
	});

	jQuery('.glossary-nav a').click(function(e) {
		e.preventDefault();
		if(jQuery(this).attr("href") == "#top"){
			var top = 0;
		}else{
			var top = jQuery(this.hash).offset().top - 60;
		}

		jQuery('body,html').animate({
			scrollTop: top
		}, 1000 );
	});
	jQuery(window).scroll(function() {
		var scrollbarLocation = jQuery(this).scrollTop();
		scrollLink.each(function() {
			var sectionOffset = jQuery(this.hash)?.offset()?.top - 60;
			if ( sectionOffset <= scrollbarLocation ) {
				jQuery(this).addClass('active');
				jQuery(this).siblings().removeClass('active');
			}
		});
	});
	/* glossary content js end */

	// start search 
	var searchInput = $('.seacch-form input');
	var suggestionsContainer = $('#suggestions');
	var suggestionsparent = $('.suggestions_parent');

	suggestionsparent.hide();

	searchInput.on('input', function () {
		var searchTerm = $(this).val().toLowerCase();

	  // Check if the search term is empty
		if (searchTerm === '') {
			suggestionsparent.hide();
			$(".seacch-form input").removeClass("suggetion-open");
			return;
		}

	  // Find all suggestions that match the search term
		var matchingSuggestions = findMatchingSuggestions(searchTerm);

		displaySuggestions(matchingSuggestions);
	});

	function findMatchingSuggestions(searchTerm) {
		var matchingSuggestions = [];
		var allBtags = $('.glossary-content-wapper .container p b');

		allBtags.each(function () {
			var textContent = $(this).text().toLowerCase();
			if (startsWithIgnoreCase(textContent, searchTerm)) {
				matchingSuggestions.push(textContent);
			}
		});

		return matchingSuggestions;
	}

	function startsWithIgnoreCase(str, prefix) {
		return str.toLowerCase().startsWith(prefix);
	}

	function displaySuggestions(suggestions) {
		if (suggestions.length === 0) {
			suggestionsparent.hide();
			$(".seacch-form input").removeClass("suggetion-open");
			return;
		}

		suggestionsContainer.empty();

		$.each(suggestions, function (index, item) {
			var suggestionElement = $('<span>').text(item);

			suggestionElement.on('click', function (event) {
				event.preventDefault();
				searchInput.val(item);
				suggestionsparent.hide();
				$(".seacch-form input").removeClass("suggetion-open");

		  		// Scroll to the corresponding section based on the clicked suggestion's content
				var targetSection = findSectionByContent(item);

				if (targetSection) {
					targetSection[0].scrollIntoView({ behavior: 'smooth' });
				}
			});

			suggestionsContainer.append(suggestionElement);
		});

		suggestionsparent.show();

		$(".seacch-form input").addClass("suggetion-open");
	}

	function findSectionByContent(content) {
	  // Loop through all sections to find the one containing the clicked content
		var allSections = $('.glossary-content-wapper .container p b');

		for (var i = 0; i < allSections.length; i++) {
			var section = $(allSections[i]);
			var sectionContent = section.text().toLowerCase();

			if (sectionContent.includes(content.toLowerCase())) {
				return section.closest('.glossary-content-card b');
			}
		}

	  return null; // Return null if no matching section is found
	}


	var searchInput = $('.seacch-form input');
	var searchIconLink = $('#searchIconLink');
	
	searchInput.on('keyup', function () {
		var inputValue = $(this).val().trim();
		
	  // Check if the input value is empty
		if (inputValue === '') {
		// Show the image
			searchIconLink.css('display', 'inline-block');
		} else {
		// Hide the image
			searchIconLink.css('display', 'none');
		}
	});
	//end search
	
})
