@include('header')
@include('functions')

<?php use App\Models\BlogCategories; ?>

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/author-page.css">

<!-- author banner section start -->
<div class="author-banner-section-r">
	<div class="container w-1280">
		<div class="author-banner-r-wapper">
			<div class="main-author-banner-top-link">
				<ul>
					<li><a href="{{ url('/') }}/edu/" title="Home">Advisor</a></li>
					<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<li><a href="#">  Legal </a></li>
				</ul>
			</div>
			<div class="author-banner-card-wapper">
				<div class="author-banner-card-profile-wapper">
					<div class="author-banner-card-profile-img-name">
						<div class="author-banner-card-profile-img">
							<a href="{{ url('/') }}/edu/{{ $author_data->slug }}">
								<img src="{{ $author_data->profile_picture != NULL ? $author_data->profile_picture : url('/').'/img/d_user.png' }}" alt="">
							</a>
						</div>
						<div class="author-banner-card-profile-name">
							<h2>{{ $author_data->name }}</h2>
						</div>
					</div>
					<div class="author-banner-card-profile-social-icon">
						<ul>
							<?php if($author_data->facebook_link != ""){ ?>
								<li><a href="{{ $author_data->facebook_link }}"><img src="{{ url('/') }}/img/Group 76.png" alt=""></a></li>
							<?php } ?>

							<?php if($author_data->twitter_link != ""){ ?>
								<li><a href="{{ $author_data->twitter_link }}"><img src="{{ url('/') }}/img/Group 12.png" alt=""></a></li>
							<?php } ?>
							
							<?php if($author_data->linkedin_link != ""){ ?>
								<li><a href="{{ $author_data->linkedin_link }}"><img src="{{ url('/') }}/img/Group 78.png" alt=""></a></li>
							<?php } ?>
						</ul>
					</div>
				</div>
				<div class="author-banner-card-inner-text">
					<p>{{ $author_data->content }}</p>
				</div>
				<div class="author-banner-card-social-icon-wapper">
					<ul>
						<?php if($author_data->facebook_link != ""){ ?>
							<li><a href="{{ $author_data->facebook_link }}"><img src="{{ url('/') }}/img/Group 76.png" alt=""></a></li>
						<?php } ?>

						<?php if($author_data->twitter_link != ""){ ?>
							<li><a href="{{ $author_data->twitter_link }}"><img src="{{ url('/') }}/img/Group 12.png" alt=""></a></li>
						<?php } ?>

						<?php if($author_data->linkedin_link != ""){ ?>
							<li><a href="{{ $author_data->linkedin_link }}"><img src="{{ url('/') }}/img/Group 78.png" alt=""></a></li>
						<?php } ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
</div>

<!-- author banner section end -->


<!-- Atricles written section start -->

<div class="atricles-written-section">
	<div class="container w-1280">
		<?php if($blogs->count() > 0){ ?>
			<div class="atricles-written-title-text">
				<h2>Articles written by {{ $author_data->name }} </h2>
			</div>

			<div class="atricles-written-row-wapper">
				<?php foreach($blogs as $blog){
					$catdt = BlogCategories::where('id', $blog->category)->first();
					$blog_url = url('/').'/edu/'.$catdt->slug.'/'.$blog->slug;
					if($catdt->parent_id != ""){
						$catparentdt = BlogCategories::where('id', $catdt->parent_id)->first();
						$blog_url = url('/').'/edu/'.$catparentdt->slug.'/'.$catdt->slug.'/'.$blog->slug;
					} ?>
					
					<div class="atricles-written-card-wapper">
						<div class="atricles-written-card-img">
							<a href="{{ $blog_url }}">
								<img src="{{ $blog->featured_image != NULL ? $blog->featured_image : url('/').'/img/placeholder_image.svg' }}" alt="">
							</a>
						</div>
						<div class="atricles-written-card-inner">
							<span>{{ $catdt->name }}</span>

							<div class="atricles-written-card-inner-text">
								<?php if ($blog->written){ ?>
									<h6>Written by <a href="{{ url('/') }}/author/{{ $blog->written->slug }}">{{ $blog->written->name }}</a></h6>
								<?php } ?>

								<h3><a href="{{ $blog_url }}">{{ $blog->name }}</a></h3>
								<h5>UPDATED {{ date("M d,Y", strtotime($blog->updated_at)); }}</h5>
								<p><?php echo substr(strip_tags($blog->content),0,110) . "..."; ?></p>
							</div>
						</div>
					</div>
				<?php } ?>
			</div>

			<div class="atricles-written-Pagination-wapper">
				{{ $blogs->links("pagination::bootstrap-5") }}
			</div>
		<?php }else{ ?>
			<p>We are still evaluating lawyers to feature in this directory. In the meantime, consider expanding your search to a wider area.</p>
		<?php } ?>
	</div>
</div>

<!-- Atricles written section end -->
<script src="{{ url('/') }}/js/author-page.js"></script>

@include('footer')