<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/css/glossary-of-legal-terms.css">

<script src="<?php echo e(url('/')); ?>/js/glossary-of-legal-terms.js"></script>

<script>

document.addEventListener('DOMContentLoaded', function () {
    const glossaryNavLinks = document.querySelectorAll('.glossary-nav a');

    glossaryNavLinks.forEach(link => {
        link.addEventListener('click', function() {
            glossaryNavLinks.forEach(l => l.classList.remove('active'));
            this.classList.add('active');
        });
    });
});

</script>

<!-- glossary page banner section html start -->
<section class="glossary-banner-wapper">
	<div class="container w-1280">
		<div class="glossary-banner-card">
			<h1>Glossary of Legal Terms</h1>
			<p>Understand the meaning of intricate legal terms with our exhaustive guide. Perfect for both budding law students and seasoned attorneys. </p>
			<?php echo $__env->make('templates/top_search_glossary', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
		</div>
	</div>
</section>

<!-- Glossary index section html start -->

<?php if(!empty($glossaries)): ?>

	<section class="glossary-section-wapper">
		<div class="container w-1280">
			<div class="glossary-nav-wapper">
				<div class="glossary-nav">
				    <?php $__currentLoopData = range('A', 'Z'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<?php if(isset($glossaries[$letter]) && count($glossaries[$letter]) > 0): ?>
					        <a href="#<?php echo e($letter); ?>" class="<?php echo e(request()->get('letter') == $letter ? 'active' : ''); ?>"><?php echo e($letter); ?></a>
					<?php else: ?>
						<a href="" class=""><?php echo e($letter); ?></a>
					<?php endif; ?>
				    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<a href="#top">Top</a>
				</div>
			</div>
		</div>
	</section>

<section class="glossary-content-wapper">
    <div class="container w-1280">
        <?php $__currentLoopData = $glossaries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter => $entries): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="glossary-content-card" id="<?php echo e($letter); ?>">
                <h3><?php echo e($letter); ?></h3>
                <?php $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p><b><?php echo e($entry->name); ?></b> - <?php echo e($entry->definition); ?></p>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</section>

<?php endif; ?>


<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/glossary/index.blade.php ENDPATH**/ ?>