<?php

use Illuminate\Support\Facades\Route;

// --------------------------
// Custom Backpack Routes
// --------------------------
// This route file is loaded automatically by Backpack\Base.
// Routes you generate using Backpack\Generators will be placed here.

Route::group([
    'prefix'     => config('backpack.base.route_prefix', 'admin'),
    'middleware' => array_merge(
        (array) config('backpack.base.web_middleware', 'web'),
        (array) config('backpack.base.middleware_key', 'admin'),
    ),
    'namespace'  => 'App\Http\Controllers\Admin',
], function () { // custom admin routes
    Route::crud('user', 'UserCrudController');
    Route::crud('listing', 'ListingCrudController');
    Route::crud('practice-area', 'PracticeAreaCrudController');
    Route::crud('address', 'AddressCrudController');
    Route::crud('county', 'CountyCrudController');
    Route::crud('firm', 'FirmCrudController');
    Route::crud('district', 'DistrictCrudController');
    Route::crud('fee', 'FeeCrudController');
    Route::crud('glossary', 'GlossaryCrudController');
    Route::crud('state', 'StateCrudController');
    Route::crud('language', 'LanguageCrudController');
    Route::crud('listingverification', 'ListingverificationCrudController');
    Route::crud('practice-area-and-state-content', 'PracticeAreaAndStateContentCrudController');
    Route::crud('practice-area-state-county-content', 'PracticeAreaStateCountyContentCrudController');
    Route::crud('listing-reviews', 'ListingReviewsCrudController');
    Route::crud('referrals', 'ReferralsCrudController');
    Route::crud('practice-area-state-city-content', 'PracticeAreaStateCityContentCrudController');
    Route::crud('department', 'DepartmentCrudController');
    Route::crud('position', 'PositionCrudController');

    Route::crud('job-applications', 'JobApplicationsCrudController');
    Route::crud('blog-categories', 'BlogCategoriesCrudController');
    Route::crud('blogs', 'BlogsCrudController');

    Route::get('user/filter/lawyers', 'UserCrudController@filterLawyers')->name('user.filterLawyers');
    Route::crud('shortcode', 'ShortcodeCrudController');
    Route::crud('theme2', 'Theme2CrudController');
    Route::crud('theme3', 'Theme3CrudController');
    Route::crud('form', 'FormCrudController');
    Route::crud('dyform', 'DyformCrudController');
}); // this should be the absolute last line of this file
