<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class NotificationVerificationEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     */
    public function __construct($user, $entry)
    {
        $this->user = $user;
	$this->entry = $entry;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: 'Document Verification Request | Legal.com',
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {
	
        return new Content(
            view: 'emails.notification-verification',
        );
	

    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }

	public function build()
	{

		$this->subject('Document Verification Request | Legal.com')
	         ->from('info@legal.com')
	         ->view('emails.notification-verification')
		 ->with(['user' => $this->user, 'entry' => $this->entry]);


	    return $this;
	}

}
