@include('header')
@include('functions')

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/state-page.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/map-css.css">

<!-- banner section start -->
<div class="banner-section-wapper">
	<div class="container w-1280">
		<div class="banner-main-wapper">
			<div class="banner-title">
				<h1>
					<span>
						<?php 
						if($city_data[0]->h1_title != ""){
							echo $city_data[0]->h1_title;
						}else{
							echo "Best Lawyers in ".ucwords($city).", ".ucwords($state);
						} ?>
					</span>
				</h1>
				<p>
					<?php 
					if($city_data[0]->short_content != ""){
						echo preg_replace('/ style=("|\')(.*?)("|\')/','', $city_data[0]->short_content);
					}else{
						echo "Discover the leading lawyers in ".ucwords($city).", ".ucwords($state)." at Legal.com. Our curated list presents attorneys who excel in the legal landscape of ".ucwords($city).", ".ucwords($state).", offering expertise across various practice areas. These professionals are dedicated to upholding your rights and navigating legal challenges to secure the best outcomes for your case.";
					} ?>
				</p>
			</div>
			<div class="banner-title-h2">
				<?php if($city_data[0]->h2_title_asc != ""){ ?>
					<h2><?php echo $city_data[0]->h2_title_asc; ?></h2>
				<?php }else{ ?>
					<h2><?php echo "Find the Best ".ucwords($city).", ".ucwords($state)." Attorney"; ?></h2>
				<?php } ?>
			</div>
			@include('templates/top_filter')
		</div>
	</div>
</div>
<!-- banner section end -->

<!-- Practice areas section html start -->
<section class="patience-areas-wapper">
	<div class="container w-1280">
		<div class="browse-by-states-section">
			<div class="browse-tab-section">
				<div class="browse-box">
					<div class="browse-bottom-border">
						<ul class="browse-tabs">
							<li class="browse-tab active" tab="t1"><a href="javascript:void(0)"> Browse by Practice Areas</a>
							</li>
						</ul>
					</div>
					<div id="t1" class="content active">
						<?php if(!empty($data['p_areas'])){ ?>
							<div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 row-cols-lg-5" >

								<?php foreach($data['p_areas'] as $p_a){
									$city = str_replace(".","",$city); ?>

									<div class="col">
										<div class="browse-states browse-pa-list">
											<p>
												<a href="{{ url('/') }}/lawyers/pa/{{ $p_a['slug'] }}/{{strtolower(str_replace(' ', '-', $state))}}/{{strtolower(str_replace(' ', '-', $city))}}" title="<?php echo $p_a['name']; ?>"><?php echo strWordCut($p_a['name'],20,$end='...'); ?></a>
												<a class="m-pa-list-anchor" href="{{ url('/') }}/lawyers/pa/{{ $p_a['slug'] }}/{{strtolower(str_replace(' ', '-', $state))}}/{{strtolower(str_replace(' ', '-', $city))}}" title="<?php echo $p_a['name']; ?>"><?php echo strWordCut($p_a['name'],15,$end='...'); ?></a>
											</p>
										</div>
									</div>
								<?php } ?>

							</div>
							<?php if(sizeof($data['p_areas']) > 40){ ?>
								<div class="load-more">
									<a href="#" class="loadMore_pa">Show More</a>
								</div>
							<?php } ?>
							
						<?php }else{ ?>
							<p class="text-center">We are still evaluating lawyers to feature in this directory. In the meantime, consider expanding your search to a wider area.</p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>
<!-- Patience areas section html end -->

<!--  state page section html start -->
<section class="personal-lawyer-wapper">
	<div class="pl-top-shape">
		<div class="container w-1280">
			<div class="learn-about-wapper">
				<div class="state-page-wapper">
					<div class="state-of-oregon-left-wapper">
						<?php echo preg_replace('/ style=("|\')(.*?)("|\')/','', $city_data[0]->description); ?>
					</div>
				</div>
				
				<?php if(!empty($faqs)){ ?>
					<div class="review-faq-wapper">
						<h2>FAQ</h2>
						<div class="faq-accordion-wapper">

							<?php foreach($faqs as $faq){ ?>
								<div class="faq-accordion-item">
									<div class="d-flex align-items-baseline faq-menu">
										<a href="javascript:void(0)"><?php echo $faq->title; ?></a>
									</div>
									<div class="faq-content" style="">
										<?php echo $faq->answer; ?>
									</div>
								</div>
							<?php } ?>

						</div>
					</div>
				<?php } ?>

			</div>
		</div>
	</div>
</section>	
<!--  state page html end -->

<script src="{{ url('/') }}/js/state-page.js"></script>
<script src="{{ url('/') }}/js/map-js.js"></script>

@include('footer')