@include('header')
@include('functions')

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/map-css.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/toc.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/pratice-area-page.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/lawyer_list_template.css">

<!-- top link section start -->
<div class="top-link-section">
	<div class="container w-1280">
		<ul>
			<li><a href="{{ url('/') }}">Home</a></li>
			<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
			<li><a href="{{ url('/') }}/lawyers">Lawyers Directory</a></li>
			<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
			<li><a href="">{{ ucwords(str_replace("-"," ",$p_area))  }}</a></li>
			<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
			<li>Attorneys</li>
		</ul>
	</div>
</div>
<!-- top link section end -->

<!-- banner text section start -->
<div class="banner-text-section">
	<div class="container w-1280">
		<div class="banner-text-wapper">
			<h1><span>Best {{ ucwords(str_replace("-"," ",$p_area))  }} Lawyers Near You </span></h1>
			<?php if(isset(json_decode($p_area_data[0]->extras)->short_content) && json_decode($p_area_data[0]->extras)->short_content != ""){ ?>
				<p><?php echo preg_replace('/ style=("|\')(.*?)("|\')/','', json_decode($p_area_data[0]->extras)->short_content); ?></p>
			<?php }else{ ?>
				<p><?php echo "Explore the top ".ucwords(str_replace("-"," ",$p_area))." lawyers near you with Legal.com. Our selection highlights skilled attorneys who specialize in ".ucwords(str_replace("-"," ",$p_area)).", providing proficient legal representation. Committed to safeguarding your interests, these lawyers ensure personalized and effective solutions to ".ucwords(str_replace("-"," ",$p_area))." legal matters."; ?></p>
			<?php } ?>
		</div>
		<div class="banner-title-h2">
			<h2>Find the Best {{ ucwords(str_replace("-"," ",$p_area))  }} Attorney Near You</h2>
		</div>
		@include('templates/top_filter')
	</div>
</div>
<!-- banner text section end -->

<!-- browse by states section start-->
<section class="browse-by-states-wapper">
	<div class="container w-1280">
		<div class="browse-by-states-section">
			<div class="browse-tab-section">
				<div class="browse-box">
					<div class="browse-bottom-border">
						<ul class="browse-tabs">
							<li class="browse-tab active" tab="t1"><a href="javascript:void(0)"> Browse by States</a></li>
							<li class="browse-tab" tab="t2"><a href="javascript:void(0)"> Browse Related Practice Areas </a>
							</li>
						</ul>
					</div>
					<div id="t1" class="content active">
						<?php if(!empty($states)){ ?>
							<div class="row row-cols-2 row-cols-sm-2 row-cols-md-5" >
								<?php foreach($states as $state){ ?>
									<div class="col">
										<div class="browse-states">
											<p><a href="{{ url('/') }}/lawyers/pa/{{$p_area}}/{{strtolower(str_replace(' ', '-', $state))}}" title="<?php echo ucfirst($state); ?>"><?php echo str_replace('-',' ',strWordCut(ucfirst($state),25,$end='...')); ?></a></p>
										</div>
									</div>
								<?php } ?>
							</div>

							<?php if(sizeof($states) > 40){ ?> 
								<div class="load-more">
									<a href="#" class="loadMore_pa">Show More</a>
								</div>
							<?php } ?>
							
						<?php } ?>
					</div>
					<div id="t2" class="content">
						<?php if(!empty($sp_pareas)){ ?>
							<div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 row-cols-lg-5" >
								<?php foreach($sp_pareas as $parea){ ?>
									<div class="col">
										<div class="browse-states browse-pa-list">
											<p>
												<a href="{{ url('/') }}/lawyers/pa/{{ $parea['slug'] }}" title="<?php echo ucfirst($parea['name']); ?>"><?php echo strWordCut(ucfirst($parea['name']),20,$end='...'); ?></a>
												<a class="m-pa-list-anchor" href="{{ url('/') }}/lawyers/pa/{{ $parea['slug'] }}" title="<?php echo ucfirst($parea['name']); ?>"><?php echo strWordCut(ucfirst($parea['name']),15,$end='...'); ?></a>
											</p>
										</div>
									</div>
								<?php } ?>
							</div>

							<?php if(sizeof($sp_pareas) > 40){ ?> 
								<div class="load-more">
									<a href="#" class="loadMore_pa">Show More</a>
								</div>
							<?php } ?>

						<?php }else{ ?>
							<p class="text-center">We are still evaluating lawyers to feature in this directory. In the meantime, consider expanding your search to a wider area.</p>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>

		<?php if($lawyers->count() > 0){ ?>
			<div class="row lawyers_list">
				<div class="col-12 col-lg-12">
					<div class="lawyer-list-title">
						<h2>
							<?php if($p_area_data[0]->lawyer_list_title != ""){ echo $p_area_data[0]->lawyer_list_title; }
							else{ echo "Listing of Top 10 Attorneys in - ".ucwords(str_replace("-"," ",$p_area)); } ?>
						</h2>
					</div>
					<div class="lawyers-list-main">
						@include('lawyers/lawyers_pagination')
					</div>
				</div>
			</div>
		<?php } ?>

	</div>
</section>
<!-- browse by states section end-->

<!-- Legal Guides section start -->
<div class="lelgal-guides-section">
	<div class="container w-1280">
		<div class="row">

			<?php if($p_area_data[0]->description != ""){ ?>
				<div class="col-12 col-lg-3">
					<div class="right-sidebar-wapper" id="sidebar-Wrap1">
						<div class="side-bar-overflow1">
							<span class="sidebar-toc-heading">Table of content</span>
							<ul class="sidebar-text sidebar-ul"></ul>
						</div>
					</div>
				</div>
			<?php } ?>

			<div class="col-12 col-lg-9">
				<div class="learn-about-wapper">
					<?php if($p_area_data[0]->description != ""){ ?>
						<div class="learn-about-text">
							<!-- <h2>Learn About the Law</h2> -->
							<?php echo preg_replace('/ style=("|\')(.*?)("|\')/','', $p_area_data[0]->description); ?>
						</div>
					<?php } ?>

					<?php if(!empty($p_area_faqs)){ ?>
						<?php if(isset(json_decode($p_area_data[0]->extras)->faqs_title)){ ?>
							<h2 class="mt-5"><?php echo json_decode($p_area_data[0]->extras)->faqs_title; ?></h2>
						<?php } ?>

						<div class="review-faq-wapper">
							<div class="faq-accordion-wapper">
								<?php foreach($p_area_faqs as $p_faq){?>
									<div class="faq-accordion-item">
										<div class="d-flex align-items-baseline faq-menu">
											<a href="javascript:void(0)"><?php echo $p_faq->title; ?></a>
										</div>
										<div class="faq-content" style="">
											<?php echo $p_faq->answer; ?>
										</div>
									</div>
								<?php } ?>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>

			<?php if($p_area_data[0]->description != ""){ ?>
				<!-- mobile view toc button start -->
				<div class="mobile-view-toc-wapper">
					<div class="right-sidebar-wapper" id="m-sidebar-Wrap1">
						<div class="side-bar-overflow1">
							<span class="sidebar-toc-heading">Table of content</span>
							<ul class="sidebar-text sidebar-ul"></ul>
						</div>
					</div>
					<button class="m-view-toc-btn">Menu</button>
				</div>
				<!-- mobile view toc button end -->
			<?php } ?>
		</div>
		<!-- <div class="Legal-Guides-wapper">
			<h2>Legal <span>Guides</span></h2>
			<div class="injured-law-wapper legal-guides">
				<div class="Injury-Law-card-wapper">
					<h6><a href="content-page.html">Injury Law</a></h6>
					<p>Car Accidents, Medical Malpractice...</p>
				</div>
				<div class="Injury-Law-card-wapper">
					<h6><a href="content-page.html">Family Law</a></h6>
					<p>Car Accidents, Medical Malpractice...</p>
				</div>
			</div>
			<div class="read-more-btn">
				<a href="javascript:void(0)" id="legal-guides">Load more</a>
			</div>
		</div> -->
	</div>
</div>
<!-- Legal Guides section end -->

<script src="{{ url('/') }}/js/map-js.js"></script>
<script src="{{ url('/') }}/js/toc.js"></script>
<script src="{{ url('/') }}/js/pratice-area-page.js"></script>

@include('footer')