<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\FormRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class FormCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class FormCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Form::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/form');
        CRUD::setEntityNameStrings('form', 'forms');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        // CRUD::setFromDb(); // set columns from db columns.

        CRUD::column('form_name');
        CRUD::column('form_fild');

        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        // CRUD::setValidation(FormRequest::class);
        // CRUD::setFromDb(); // set fields from db columns.

        CRUD::field('form_name')->type('text');
        // CRUD::field('form_fild')->type('text');

        CRUD::field([   // repeatable
            'name'  => 'form_fild',
            'label' => 'Form Fild',
            'type'  => 'repeatable',
            'subfields' => [ // also works as: "fields"
                [
                    'name'    => 'fild_lable',
                    'type'    => 'text',
                    'label'   => 'Fild Lable',
                    'wrapper' => ['class' => 'form-group col-md-4'],
                ],
    //             [   // select2_from_array
				//     'name'        => 'fild_type',
				//     'label'       => "Fild Type",
				//     'type'        => 'select2_from_array',
				//     'options'     => [  'button',
				// 					    'checkbox',
				// 					    'color',
				// 					    'date',
				// 					    'datetime-local',
				// 					    'email',
				// 					    'file',
				// 					    'hidden',
				// 					    'image',
				// 					    'month',
				// 					    'number',
				// 					    'password',
				// 					    'radio',
				// 					    'range',
				// 					    'reset',
				// 					    'search',
				// 					    'submit',
				// 					    'tel',
				// 					    'text',
				// 					    'time',
				// 					    'url',
				// 					    'week'],
				//     'allows_null' => false,
				//     'default'     => 18,
				// ],
				// [   // Switch
				//     'name'  => 'switch',
				//     'type'  => 'switch',
				//     'label'    => 'Required',

				//     // optional
				//     'color'    => 'primary', // May be any bootstrap color class or an hex color
				//     'onLabel' => '✓',
				//     'offLabel' => '✕',
				// ],
            ],
        ]);

        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
