
<?php
    $field['value'] = old_empty_or_null($field['name'], '') ?? $field['value'] ?? $field['default'] ?? '0';
    $field['onLabel'] = $field['onLabel'] ?? '';
    $field['offLabel'] = $field['offLabel'] ?? '';
    $field['color'] = $field['color'] ?? 'primary';
?>


<?php echo $__env->make('crud::fields.inc.wrapper_start', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    
    <?php echo $__env->make('crud::fields.inc.translatable_icon', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div class="d-inline-flex align-items-center">
        
        <label class="form-switch switch switch-sm switch-label switch-pill switch-<?php echo e($field['color']); ?> mb-0" style="--bg-color: <?php echo e($field['color']); ?>;">
            <input
                type="hidden"
                name="<?php echo e($field['name']); ?>"
                value="<?php echo e((int) $field['value']); ?>" />
            <input
                type="checkbox"
                data-init-function="bpFieldInitSwitch"
                <?php echo e((bool) $field['value'] ? 'checked' : ''); ?>

                class="switch-input form-check-input" />
            <span
                class="switch-slider"
                data-checked="<?php echo e($field['onLabel'] ?? ''); ?>"
                data-unchecked="<?php echo e($field['offLabel'] ?? ''); ?>">
            </span>
        </label>

        
        <label class="font-weight-normal mb-0 ml-2"><?php echo $field['label']; ?></label>
    </div>

    
    <label class="d-inline-flex m-0">&nbsp;</label>

    
    <?php if(isset($field['hint'])): ?>
        <p class="help-block"><?php echo $field['hint']; ?></p>
    <?php endif; ?>
<?php echo $__env->make('crud::fields.inc.wrapper_end', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>






<?php $__env->startPush('crud_fields_scripts'); ?>
    <?php $bassetBlock = 'backpack/crud/fields/switch-field.js'; ob_start(); ?>
    <script>
        function bpFieldInitSwitch($element) {
            let element = $element[0];
            let hiddenElement = element.previousElementSibling;
            let id = `switch_${hiddenElement.name}_${Math.random() * 1e18}`;

            // set unique IDs so that labels are correlated with inputs
            element.setAttribute('id', id);
            element.parentElement.nextElementSibling.setAttribute('for', id);

            // set the default checked/unchecked state
            // if the field has been loaded with javascript
            hiddenElement.value !== '0'
                ? element.setAttribute('checked', true)
                : element.removeAttribute('checked');

            // JS Field API
            $(hiddenElement).on('CrudField:disable', () => element.setAttribute('disabled', true));
            $(hiddenElement).on('CrudField:enable', () => element.removeAttribute('disabled'));

            // when the checkbox is clicked
            // set the correct value on the hidden input
            $element.on('change', () => {
                hiddenElement.value = element.checked ? 1 : 0;
                hiddenElement.dispatchEvent(new Event('change'));
            });
        }
    </script>
    <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('crud_fields_styles'); ?>
    <?php $bassetBlock = 'backpack/crud/fields/switch-field.css'; ob_start(); ?>
    <style>
        .switch-input:checked+.switch-slider {
            background-color: var(--bg-color);
        }
    </style>
    <?php Basset::bassetBlock($bassetBlock, ob_get_clean()); ?>
<?php $__env->stopPush(); ?>



<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/vendor/backpack/crud/fields/switch.blade.php ENDPATH**/ ?>