<?php

namespace Backpack\BackupManager\app\Http\Controllers;

use Artisan;
use Carbon\Carbon;
use Exception;
use Illuminate\Routing\Controller;
use League\Flysystem\Local\LocalFilesystemAdapter;
use Log;
use Request;
use Storage;
use App\Models\Backup;
class BackupController extends Controller
{
    public function index()
    {
        if (!count(config('backup.backup.destination.disks'))) {
            echo "500";
            // abort(500, trans('backpack::backup.no_disks_configured'));
        }

        $this->data['backups'] = [];

        foreach (config('backup.backup.destination.disks') as $diskName) {
            $disk = Storage::disk($diskName);
            $files = $disk->allFiles();

            // make an array of backup files, with their filesize and creation date
            foreach ($files as $file) {
                // remove diskname from filename
                $fileName = str_replace('backups/', '', $file);
                $downloadLink = route('backup.download', ['file_name' => $fileName, 'disk' => $diskName]);
                $deleteLink = route('backup.destroy', ['file_name' => $fileName, 'disk' => $diskName]);

                // only take the zip files into account
                if (substr($file, -4) == '.zip' && $disk->exists($file)) {
                    $this->data['backups'][] = (object) [
                        'filePath'     => $file,
                        'fileName'     => $fileName,
                        'fileSize'     => round((int) $disk->size($file) / 1048576, 2),
                        'lastModified' => Carbon::createFromTimeStamp($disk->lastModified($file))->formatLocalized('%d %B %Y, %H:%M'),
                        'diskName'     => $diskName,
                        // 'downloadLink' => is_a($disk->getAdapter(), LocalFilesystemAdapter::class, true) ? $downloadLink : null,
                        'downloadLink' => $downloadLink,
                        'deleteLink'   => $deleteLink,
                    ];
                }
            }
                echo "<pre>";
                echo $disk;
        echo "</pre>";
        }

        // reverse the backups, so the newest one would be on top
        $this->data['backups'] = array_reverse($this->data['backups']);
        $this->data['title'] = trans('backpack::backup.backups');
        die;
        return view('backupmanager::backup', $this->data);
    }

    public function create()
    {
         $command = config('backpack.backupmanager.artisan_command_on_button_click') ?? 'backup:run';
        try {
            foreach (config('backpack.backupmanager.ini_settings', []) as $setting => $value) {
                ini_set($setting, $value);
            }

            Log::info('Backpack\BackupManager -- Called backup:run from admin interface');

            Artisan::call($command);

            $output = Artisan::output();
            if (strpos($output, 'Backup failed because')) {
                preg_match('/Backup failed because(.*?)$/ms', $output, $match);
                $message = "Backpack\BackupManager -- backup process failed because ".($match[1] ?? '');
                Log::error($message.PHP_EOL.$output);

                return response($message, 500);
            }
            // else{

            //     $diskNames = config('backup.backup.destination.disks');

            //     foreach ($diskNames as $diskName) {
            //         $disk = Storage::disk($diskName);
            //         $files = $disk->allFiles();
            //         $latestFile = end($files); // Get the latest backup file
                
            //         // Calculate file size
            //         $backupSize = round((int) $disk->size($latestFile) / 1048576, 2);
                  
            //         // Create backup record in the database
            //         Backup::create([
            //             'name' => pathinfo($latestFile, PATHINFO_FILENAME),
            //             'disk' => $diskName,
            //             'file_path' => $latestFile,
            //             'file_size' => $backupSize,
            //             'created_at' => now(),
            //         ]);
            //     }
            // }
        } catch (Exception $e) {
            Log::error($e);

            return response($e->getMessage(), 500);
        }

        return true;
    }

    /**
     * Downloads a backup zip file.
     */
    public function download()
    {
        $diskName = Request::input('disk');
        $fileName = Request::input('file_name');
        $disk = Storage::disk($diskName);

        if (!$this->isBackupDisk($diskName)) {
            abort(500, trans('backpack::backup.unknown_disk'));
        }

        if (!is_a($disk->getAdapter(), LocalFilesystemAdapter::class, true)) {
            abort(404, trans('backpack::backup.only_local_downloads_supported'));
        }

        if (!$disk->exists($fileName)) {
            abort(404, trans('backpack::backup.backup_doesnt_exist'));
        }

        return $disk->download($fileName);
    }

    /**
     * Deletes a backup file.
     */
    public function delete()
    {
        $diskName = Request::input('disk');
        $fileName = Request::input('file_name');

        if (!$this->isBackupDisk($diskName)) {
            return response(trans('backpack::backup.unknown_disk'), 500);
        }

        $disk = Storage::disk($diskName);

        if (!$disk->exists($fileName)) {
            return response(trans('backpack::backup.backup_doesnt_exist'), 404);
        }

        return $disk->delete($fileName);

    }

    /**
     * Check if disk is a backup disk.
     *
     * @param string $diskName
     *
     * @return bool
     */
    private function isBackupDisk(string $diskName)
    {
        return in_array($diskName, config('backup.backup.destination.disks'));
    }
}
