<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\Mail;

class LawyerContactEmail extends Mailable
{
    use Queueable, SerializesModels;

    public $lcontact;
    /**
     * Create a new message instance.
     */
    public function __construct($lcontact)
    {
        $this->lcontact = $lcontact;
    }

    /**
     * Get the message envelope.
     */
    public function envelope(): Envelope
    {
        return new Envelope(
            subject: $this->lcontact->subject,
        );
    }

    /**
     * Get the message content definition.
     */
    public function content(): Content
    {

        return new Content(
            view: 'emails.lcontact',
        );


    }

    /**
     * Get the attachments for the message.
     *
     * @return array<int, \Illuminate\Mail\Mailables\Attachment>
     */
    public function attachments(): array
    {
        return [];
    }

    public function build()
    {
        $this->subject($this->lcontact->subject)
        ->from('no-reply@legal.com')
        ->view('emails.lcontact')
        ->with(['user' => $this->lcontact]);

        return $this;
    }

}
