<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateListingAddressesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('listing_address', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('listing_id');
	    $table->text('label');
            $table->text('full_address');
            $table->text('county')->nullable();
            $table->text('city');
            $table->text('state');
            $table->text('country');
            $table->text('lat')->nullable();
            $table->text('lng')->nullable();
            $table->text('zipcode');
	    $table->boolean('primary');
	    $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('listing_address');
    }
}
