<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\StateRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class StateCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class StateCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\State::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/state');
        CRUD::setEntityNameStrings('state', 'states');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        CRUD::column('url_index')->label('Url Index');
        CRUD::column('name')->label('Name');
        CRUD::column('abbreviation')->label('Abbreviation');
        CRUD::column('description')->label('Description');

        CRUD::column([
            'name'  => 'view_link',
            'label' => 'View Front',
            'type'  => 'model_function',
            'function_name' => 'getfrontlink', 
            'limit' => 10000,
            'escaped' => false,
        ]);
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::field([ 
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
        ]); 
        CRUD::field('name')->type('text');
        CRUD::field('abbreviation')->type('text');
        CRUD::field('h1_title')->type('text');
        CRUD::field('short_content')->type('summernote')->label('Short content');
        CRUD::field('h2_title_asc')->type('text')->label('H2 After Short Content');
        CRUD::field('lawyer_list_title')->type('text');
        CRUD::field('description')->type('summernote')->label('Description');

        CRUD::field([
            'tab'           => 'Frequently Asked Questions',
            'label'         => 'FAQs',
            'type'          => "relationship",
            'model'         => 'App\Models\StateFaq',
            'pivot'         => true,
            'entity'        => 'faqs',
            'name'          => 'faqs',
            'subfields'   => [
                [
                    'name' => 'title',
                    'label' => 'Title',
                    'type' => 'text',
                    'wrapper' => [
                        'class' => 'form-group col-md-12',
                    ],
                ],

                [
                    'name' => 'answer',
                    'label' => 'Answer',
                    'type' => 'textarea',
                    'wrapper' => [
                        'class' => 'form-group col-md-12',
                    ],
                ],
            ],
        ]);


        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
