<?php echo $__env->make('header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('functions', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/css/find-a-lawyers.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/css/map-css.css">
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/css/toc.css">
<div class="top-link-section">
    <div class="container w-1280">
        <ul>
            <li><a href="<?php echo e(url('/')); ?>">Home</a></li>
            <li><img src="<?php echo e(url('/')); ?>/img/right-icon.svg" alt=""></li>
            <li><a href="">Lawyer Directory</a></li>
        </ul>
    </div>
</div>
<!-- banner section start -->
<div class="banner-section-wapper">
    <div class="container w-1280">
        <div class="banner-main-wapper">
            <div class="banner-title">
                <h1><span><?php echo $page['name']; ?></span></h1>
                <p><?php echo $page->extras['short_content']; ?></p>
            </div>
            <div class="banner-title-h2">
                <?php if($page->extras['h2_after_short_description'] != ""){ ?>
                    <h2><?php echo $page->extras['h2_after_short_description']; ?></h2>
                <?php } ?>
            </div>
            <?php echo $__env->make('templates/top_filter', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>
</div>
<!-- banner section end -->

<!-- Patience areas section html start -->
<section class="patience-areas-wapper">
    <div class="container w-1280">
        <div class="browse-by-states-section">
            <div class="browse-tab-section">
                <div class="browse-box">
                    <div class="browse-bottom-border">
                        <ul class="browse-tabs">
                            <li class="browse-tab active" tab="t1"><a href="javascript:void(0)"> Browse by Practice Areas</a>
                            </li>
                            <li class="browse-tab" tab="t2"><a href="javascript:void(0)"> Browse by States</a></li>
                        </ul>
                    </div>
                    <div id="t1" class="content active">
                        <?php if(!empty($data['p_areas'])){ ?>
                            <div class="row row-cols-2 row-cols-sm-2 row-cols-md-3 row-cols-lg-5" >

                                <?php foreach($data['p_areas'] as $p_a){ ?>
                                    <div class="col">
                                        <div class="browse-states browse-pa-list">
                                            <p>
                                                <a href="<?php echo e(url('/')); ?>/lawyers/pa/<?php echo e($p_a['slug']); ?>" title="<?php echo $p_a['name']; ?>"><?php echo strWordCut($p_a['name'],20,$end='...'); ?></a>
                                                <a class="m-pa-list-anchor" href="<?php echo e(url('/')); ?>/lawyers/pa/<?php echo e($p_a['slug']); ?>" title="<?php echo $p_a['name']; ?>"><?php echo strWordCut($p_a['name'],15,$end='...'); ?></a>
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>

                            <?php if(sizeof($data['p_areas']) > 40){ ?>
                                <div class="load-more">
                                    <a href="javascript:void(0)" class="loadMore_pa">Show More</a>
                                </div>
                            <?php } ?>

                            <input type="hidden" id="l_parea_btn" value="0">
                            <input type="hidden" id="l_all_parea_link" value="<?php echo e(url('/')); ?>/lawyers/all-practice-areas">
                        <?php } ?>
                    </div>
                    <div id="t2" class="content ">
                        <?php if(!empty($data['states'])){ ?>
                            <div class="row row-cols-2 row-cols-sm-2 row-cols-md-5" >
                                <?php foreach($data['states'] as $state){ ?>
                                    <div class="col">
                                        <div class="browse-states browse-pa-list">
                                            <p>
                                                <a href="<?php echo e(url('/')); ?>/lawyers/loc/<?php echo e(strtolower(str_replace(' ', '-', $state))); ?>" title="<?php echo $state; ?>"><?php echo strWordCut($state,25,$end='...'); ?></a>
                                            </p>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>

                            <?php if(sizeof($data['states']) > 40){ ?>
                                <div class="load-more">
                                    <a href="#" class="loadMore_pa">Show More</a>
                                </div>
                            <?php } ?>
                        <?php } ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Patience areas section html end -->

<?php echo $__env->make('templates/state_template', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php 
$faqs = $page->extras['faqs'];
if($page->extras['content_title'] != "" || $faqs != null){ ?>
    <div class="lelgal-guides-section">
        <div class="container w-1280">  

            <div class="row">
                <?php if(!empty($page->extras['full_content'])){ ?>
                    <div class="col-12 col-lg-3">
                        <div class="right-sidebar-wapper" id="sidebar-Wrap1">
                            <div class="side-bar-overflow1">
                                <span class="sidebar-toc-heading">Table of content</span>
                                <ul class="sidebar-text sidebar-ul"></ul>
                            </div>
                        </div>
                    </div>
                <?php } ?>

                <div class="col-12 col-lg-9">
                    <div class="learn-about-wapper">
                        <div class="learn-about-text">
                            <?php if($page->extras['content_title'] != ""){ ?>
                                <h2><?php echo $page->extras['content_title']; ?></h2>
                                <?php echo $page->extras['full_content']; ?>
                            <?php } ?>
                        </div>

                        <?php if(!empty($faqs)){ ?>
                            <div class="review-faq-wapper">
                                <?php if($page->extras['faq_main_title'] != ""){ ?>
                                    <h2><?php echo $page->extras['faq_main_title']; ?></h2>
                                <?php } ?>
                                <div class="faq-accordion-wapper">
                                    <?php foreach($faqs as $faq){ ?>
                                        <div class="faq-accordion-item">
                                            <div class="d-flex align-items-baseline faq-menu">
                                                <a href="javascript:void(0)"><?php echo $faq['faq_title']; ?></a>
                                            </div>
                                            <div class="faq-content" style="display: none;">
                                                <?php echo $faq['faq_description']; ?>
                                            </div>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>

                <?php if(!empty($page->extras['full_content'])){ ?>
                    <!-- mobile view toc button start -->
                    <div class="mobile-view-toc-wapper">
                        <div class="right-sidebar-wapper" id="m-sidebar-Wrap1">
                            <div class="side-bar-overflow1">
                                <span class="sidebar-toc-heading">Table of content</span>
                                <ul class="sidebar-text sidebar-ul"></ul>
                            </div>
                        </div>
                        <button class="m-view-toc-btn">Menu</button>
                    </div>
                    <!-- mobile view toc button end -->
                <?php } ?>
            </div>

        </div>
    </div>
<?php } ?>

<script src="<?php echo e(url('/')); ?>/js/find-a-lawyers.js"></script>
<script src="<?php echo e(url('/')); ?>/js/map-js.js"></script>
<script src="<?php echo e(url('/')); ?>/js/toc.js"></script>

<?php echo $__env->make('footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/lawyers/lawyers_page.blade.php ENDPATH**/ ?>