<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
	public function up()
	{
	    Schema::table('addresses', function (Blueprint $table) {
	        // Rename address1 to address
	        $table->renameColumn('address1', 'address');

	        // Drop address2 column
	        $table->dropColumn('address2');
	    });
	}

    /**
     * Reverse the migrations.
     */
	public function down()
	{
	    Schema::table('addresses', function (Blueprint $table) {
	        // Reverse the column name change
	        $table->renameColumn('address', 'address1');

	        // Add back the address2 column if necessary
	        $table->string('address2')->nullable(); // Adjust the data type as per your needs
	    });
	}

};
