<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\PositionRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class PositionCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class PositionCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Position::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/position');
        CRUD::setEntityNameStrings('position', 'positions');
    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
//        CRUD::setFromDb(); // set columns from db columns.

        CRUD::column('department_id')->label('Department')
        ->type('select')
        ->name('department_id')
        ->entity('department')
        ->attribute('name')
        ->model('App\Models\Department');

	CRUD::column('title')->label('Title');
	CRUD::column('salary')->label('Salary');
        CRUD::column('city')->label('City');
        CRUD::column('state')->label('State');
        CRUD::column('country')->label('Country');

//	CRUD::column('content')->label('Content');
        /**
         * Columns can be defined using the fluent syntax:
         * - CRUD::column('price')->type('number');
         */
    }

    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(PositionRequest::class);
//        CRUD::setFromDb(); // set fields from db columns.

	CRUD::field('department_id')->label('Department')->type('select2')
		->entity('department')
		->attribute('name')
		->model("App\Models\Department");

        CRUD::field([
            'name'  => 'title',
            'label' => 'Title',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-8',
            ],
        ]);

	CRUD::field([
            'name'  => 'salary',
            'label' => 'Salary',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ]);

        CRUD::field([
            'name'  => 'city',
            'label' => 'City',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ]);

        CRUD::field([
            'name'  => 'state',
            'label' => 'State',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ]);

        CRUD::field([
            'name'  => 'country',
            'label' => 'Country',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ]);

	CRUD::field([
            'name'  => 'content',
            'label' => 'Content',
            'type'  => 'summernote',
            'wrapper' => [
                'class' => 'form-group col-md-12',
            ],
    	    'options' => [
        	'toolbar' => [
        	    ['font', ['bold', 'underline', 'italic']]
        	]
	    ],
        ]);

        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
}
