<?php
namespace App\Http\Controllers;
use Srmklive\PayPal\Services\PayPal as PayPalClient;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;

class PayPalController extends Controller{
    /**
     * Write code on Method
     *
     * @return response()
     */

    public function payment(Request $request)
    {   
        $price = str_replace("$", "", $request->price);

        Session::put('price', $request->price);
        Session::put('premium_months', $request->premium_months);

        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $paypalToken = $provider->getAccessToken();

        $response = $provider->createOrder([
            "intent" => "CAPTURE",
            "application_context" => [
                "return_url" => route('paypal.payment.success'),
                "cancel_url" => route('paypal.payment/cancel'),
            ],

            "purchase_units" => [
                0 => [
                    "amount" => [
                        "currency_code" => "USD",
                        "value" => $price
                    ]
                ]
            ]
        ]);


        if (isset($response['id']) && $response['id'] != null) {
            foreach ($response['links'] as $links) {
                if ($links['rel'] == 'approve') {
                    return redirect()->away($links['href']);
                }
            }

            return redirect()->route('paypal')->with('error', 'Something went wrong.');

        } else {
            return redirect()->route('paypal')->with('error', $response['message'] ?? 'Something went wrong.');
        }
    }


    /**
     * Write code on Method
     *
     * @return response()
     */

    public function paymentCancel()
    {
        return redirect()->route('paypal')->with('error', $response['message'] ?? 'You have canceled the transaction.');
    }

    /**
     * Write code on Method
     *
     * @return response()
     */

    public function paymentSuccess(Request $request)
    {
        $provider = new PayPalClient;
        $provider->setApiCredentials(config('paypal'));
        $provider->getAccessToken();
        $response = $provider->capturePaymentOrder($request['token']);

        if (isset($response['status']) && $response['status'] == 'COMPLETED') {
            $user_id = Session::get('user_id');
            $price = Session::get('price');
            $premium_months = Session::get('premium_months');
            $expiry = date("Y-m-d H:i:s", strtotime( date('Y-m-d H:i:s')." +".$premium_months." month" ) );

            $id = DB::table('listing_premium_orders')->insertGetId([
                'user_id' => $user_id,
                'listing_id' => '',
                'premium_months' => $premium_months,
                'price' => $price,
                'payment_status' => $response['status'],
                'payment_details' => json_encode($response),
                'plan_expiry' => $expiry,
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ]);

            $gen_update = DB::table('listings')->where('user_id', $user_id)->update([
                'featured' => 1,
            ]);

            Session::forget('price');
            Session::forget('premium_months');

            return redirect()->route('paypal')->with('success', 'Transaction complete.');
        } else {
            return redirect()->route('paypal')->with('error', $response['message'] ?? 'Something went wrong.');
        }
    }
}