<?php
function clean($string) {
	$string = str_replace(' ', '-', $string);
	$string = preg_replace('/[^A-Za-z0-9\-]/', '-', $string);
	return ltrim(str_replace('---','-',$string), '-');
}

foreach($lawyers as $lawyer){

	$reviews = DB::table('listing_reviews')->where('listing_id', $lawyer->id)->get();
	$avg = 0;
	$total_reviews = $reviews->count();
	if($reviews->count() > 0){
		$avg = ceil($reviews->sum('rating')/$total_reviews);
	}

	if(!isset($state) || $state == ""){
		if($lawyer->address->count() > 0){
			$state = $lawyer->address->first()->state;
		}else{
			continue;
		}
	}

	$l_fname = strtolower($lawyer->first_name.'-'.($lawyer->middle_name ? $lawyer->middle_name . '-' : '').$lawyer->last_name);
	$l_fname = str_replace('.', '-', $l_fname);
	$l_fname = str_replace(',', '-', $l_fname);
	$l_fname = str_replace('`', '-', $l_fname);
	$l_fname = str_replace("'", '-', $l_fname);
	$l_fname = str_replace("(", '', $l_fname);
	$l_fname = str_replace(")", '', $l_fname);
	$l_fname = str_replace('--', '-', $l_fname); ?>

	<!-- DESKTOP VIEW -->
	<div class="lawyers-list-card <?php if($lawyer->featured){ ?>premium-card-wapper<?php } ?>">
		<div class="lawyers-list-left">
			<?php if($lawyer->featured){ ?>
				<div class="premium-list">
					<span>PREMIUM</span>
				</div>
			<?php } ?>

			<div class="lawyers-list-thumb">
				<!-- <img src="{{ $lawyer->picture != NULL ? $lawyer->picture : url('/').'/img/default_lawyer.png' }}" alt=""> -->
				<a href="{{ url('/') }}/lawyer/{{ str_replace(' ','-',$l_fname) }}-{{ $lawyer->id }}">
					<img src="{{ $lawyer->picture != NULL ? $lawyer->picture : url('/').'/img/placeholder_image.svg' }}" alt="">
				</a>
			</div>
			<div class="content-stars">
				<span class="content-stars-rating" rating="<?php echo $avg; ?>">
					<span class="star"></span>
					<span class="star"></span>
					<span class="star"></span>
					<span class="star"></span>
					<span class="star"></span>
				</span>
				<p><?php echo $total_reviews; ?> reviews</p>
			</div>
		</div>
		<div class="lawyers-list-right">
			<div class="lawyers-right-card">
				@if($lawyer->address && $lawyer->address->isNotEmpty())
				@php
				$address = $lawyer->address->first();
				@endphp
				@endif
				<p>
					<a href="{{ url('/') }}/lawyer/{{ str_replace(' ','-',$l_fname) }}-{{ $lawyer->id }}">
						{{ $lawyer->prefix ? $lawyer->prefix . '.' : '' }} {{ $lawyer->first_name }} {{ $lawyer->middle_name ? $lawyer->middle_name : '' }} {{ $lawyer->last_name }}
					</a>
				</p>
				<p>{{ $lawyer->practiceAreas->first()->name }} 
					@if($lawyer->address && $lawyer->address->isNotEmpty())
					Lawyer Serving at {{ $address->city.' - ' }} {{ $address->state }}
					@endif
				</p>

				@if($lawyer->address && $lawyer->address->isNotEmpty())
				<span class="address-card">
					<img src="{{ url('/') }}/img/location-icon.svg">
					@php
					$address = $lawyer->address->first();
					@endphp
					{{ $address->full_address}}, {{ $address->state }},  {{ $address->zipcode }}
				</span>
				@endif

				<ul>
					<!-- <li><img src="{{ url('/') }}/img/video-icon-2.svg" alt="">Offers Video Conferencing</li> -->

					@if($lawyer->education && $lawyer->education->isNotEmpty())
					<li>
						<img src="{{ url('/') }}/img/graduation.svg" alt="">
						@php
						$education = $lawyer->education->first();
						@endphp
						{{ $education->institution }}
					</li>
					@endif		

					@if ($lawyer->practiceAreas && $lawyer->practiceAreas->isNotEmpty())
					<li>
						<img src="{{ url('/') }}/img/law-icon.svg" alt="">
						@php
						$total = $lawyer->practiceAreas->count();
						$pi=0;
						@endphp
						@foreach($lawyer->practiceAreas as $index => $practiceArea)

						@if($pi < 9)

						@if($index == $total - 2 && $total > 1) 
						{{ $practiceArea->name }}
						@elseif($total == 1) 
						{{ $practiceArea->name }}
						@elseif($index == $total - 1) 
						and {{ $practiceArea->name }}
						@else 
						{{ $practiceArea->name }},
						@endif

						@else
						...
						@php
						break;
						@endphp
						@endif

						@php
						$pi++;
						@endphp

						@endforeach
					</li>
					@endif

					<li>
						<img src="{{ url('/') }}/img/experience-icon.svg" alt="">

						@if($lawyer->address && $lawyer->address->isNotEmpty())
						{{ $address->city }}, {{ $address->state }}
						{{$lawyer->practiceAreas->first()->name}} Lawyer 
						@endif


						<?php if ($lawyer->jurisdiction && $lawyer->jurisdiction->isNotEmpty()){
							if($lawyer->jurisdiction->first()->since != ""){
								$lawyer->experience_years = date("Y") - $lawyer->jurisdiction->first()->since;
							} 
						} ?>

						@if (isset($lawyer->experience_years)) 
						with {{ $lawyer->experience_years }} years of experience
						@endif
					</li>
				</ul>
			</div>
			<div class="lawyers-right-last">
				<div class="lawyers-right-last-top">
					<span><img src="{{ url('/') }}/img/check-icon.svg" alt="">Free Consultation</span>
					<?php if(isset($lawyer->phone) && $lawyer->phone != ""){?>
						<span>
							<img src="{{ url('/') }}/img/phone-icon.svg" alt="">
							<a href="tel:+<?php echo clean($lawyer->phone); ?>"><?php echo $lawyer->phone; ?></a>
						</span>
					<?php } ?>
				</div>
				<div class="lawyers-right-last-bottom">
					<?php if(isset($lawyer->url) && $lawyer->url != ""){?>
						<a href="{{$lawyer->url}}" class="website-btn">
							<img src="{{ url('/') }}/img/web-icon.svg" alt=""> View Website
						</a>
					<?php } ?>

					<?php if(isset($lawyer->email) && $lawyer->email != ""){?>
						<a href="#" data_id="{{ $lawyer->id }}" class="email-btn">
							<img src="{{ url('/') }}/img/email.svg" alt=""> Email Lawyer
						</a>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>

	<!-- MOBILE VIEW -->
	<div class="lawyers-list-m-main" data_id="{{ $lawyer->id }}">
		<div class="lawyers-list-card <?php if($lawyer->featured){ ?>premium-card-wapper<?php } ?>">
			<div class="lawyers-list-left">
				<div class="lawyers-list-thumb">
					<img src="{{ $lawyer->picture != NULL ? $lawyer->picture : url('/').'/img/placeholder_image.svg' }}" alt="">
				</div>
				<div class="lawyers-list-left-m">
					<?php if($lawyer->featured){ ?>
						<div class="premium-list">
							<span>PREMIUM</span>
						</div>
					<?php } ?>
					<p>
						<a href="{{ url('/') }}/lawyer/{{ str_replace(' ','-',$l_fname) }}-{{ $lawyer->id }}">
							{{ $lawyer->prefix ? $lawyer->prefix . '.' : '' }} {{ $lawyer->first_name }} {{ $lawyer->middle_name ? $lawyer->middle_name . '.' : '' }}{{ $lawyer->last_name }}
						</a>
					</p>
				</div>
			</div>
			<div class="content-stars">
				<span class="content-stars-rating" rating="<?php echo $avg; ?>">
					<span class="star"></span>
					<span class="star"></span>
					<span class="star"></span>
					<span class="star"></span>
					<span class="star"></span>
				</span>
				<p><?php echo $total_reviews; ?> reviews</p>
			</div>
			<div class="lawyers-list-right">
				<div class="lawyers-right-card">
					@if($lawyer->address && $lawyer->address->isNotEmpty())
					<p>
						Lawyer Serving at {{ $address->city.' - ' }} {{ $address->state }}
					</p>
					@endif
					@if($lawyer->address && $lawyer->address->isNotEmpty())
					<span class="address-card">
						<img src="{{ url('/') }}/img/location-icon.svg">
						@php
						$address = $lawyer->address->first();
						@endphp
						{{ $address->full_address}}, {{ $address->state }},  {{ $address->zipcode }}
					</span>
					@endif
				</div>
				<div class="lawyers-right-last">
					<div class="lawyers-right-last-top">
						<span>
							<img src="{{ url('/') }}/img/check-icon.svg" alt="">Free Consultation
						</span>
						<?php if(isset($lawyer->phone) && $lawyer->phone != ""){?>
							<span>
								<img src="{{ url('/') }}/img/phone-icon.svg" alt="">
								<a href="tel:+<?php echo clean($lawyer->phone); ?>"><?php echo $lawyer->phone; ?></a>
							</span>
						<?php } ?>
					</div>
					<div class="lawyers-right-last-bottom">
						<?php if(isset($lawyer->url) && $lawyer->url != ""){?>
							<a href="{{$lawyer->url}}" class="website-btn">
								<img src="{{ url('/') }}/img/web-icon.svg" alt=""> View Website
							</a>
						<?php } ?>

						<?php if(isset($lawyer->email) && $lawyer->email != ""){?>
							<a href="#" data_id="{{ $lawyer->id }}" class="email-btn">
								<img src="{{ url('/') }}/img/email.svg" alt=""> Email Lawyer
							</a>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php } ?>

<div class="lawyers-pagination">
	{{ $lawyers->links("pagination::bootstrap-5") }}
</div>

<input type="hidden" id="lawyer_id" value=''>

<script type="text/javascript">
	$(document).ready(function(){
		$(".error").fadeOut();

		function errorFadeIn(text) {
			$(".error").fadeIn();
			jQuery(".error").css("color", "#2D4E66");
			jQuery(".error").text(text);
			setTimeout(() => {
				$(".error").fadeOut();
			}, 3000);
			return false;
		}

		function errorFadeOut() {
			$(".error").fadeOut();
			jQuery(".error").css("color", "#fff");
			jQuery(".error").text("");
		}

		// CHECK IS EMAIL
		function isEmail(email) {
			var regex = /^([a-zA-Z0-9_.+-])+\@(([a-zA-Z0-9-])+\.)+([a-zA-Z0-9]{2,4})+$/;
			return regex.test(email);
		}

		var law_contact = "{{ url('/') }}/contact_lawyer";
		$(".email-btn").click(function(e){
			e.preventDefault();
			$('#contact-form-modal').modal('show');
			$("#lawyer_id").val($(this).attr("data_id"));
		});

		$('#contact_submit').click(function(e){
			e.preventDefault();
			var first_name = $("#first_name").val();
			var last_name = $("#last_name").val();
			var email = $("#email").val();
			var subject = $("#subject").val();
			var zip = $("#zip").val();
			var contact_summary = $("#contact_summary").val();
			var lawyer_id = $("#lawyer_id").val();

			const formData = new FormData();
			formData.append("first_name", first_name);
			formData.append("last_name", last_name);
			formData.append("email", email);
			formData.append("subject", subject);
			formData.append("zip", zip);
			formData.append("contact_summary", contact_summary);
			formData.append("lawyer_id", lawyer_id);

			if(first_name == "" || last_name == "" || email == "" || subject == "" || zip == ""){
				errorFadeIn("All Fields are Required");
			}else if(!isEmail(email)){
				errorFadeIn("Enter valid email addresss");
			}else if(lawyer_id == ""){
				errorFadeIn("Something went wrong");
			}else{
				errorFadeOut();

				jQuery("#contact_form").css("opacity", "0.8");

				$.ajaxSetup({
					headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
				});
				$("#ref_form_submit").attr("disabled", true);
				$.ajax({
					url: law_contact,
					type: "POST",
					data: formData,
					processData: false,
					contentType: false,
					success: function (response) {
						var response = JSON.parse(response);
						jQuery("#contact_form").css("opacity", "1");

						if(response.error == ""){
							errorFadeIn(response.success);
						}else{
							jQuery(".form_res").fadeOut();
							errorFadeIn(response.error);
						}
					},
				});
			}
		});
	});
</script>