<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Mail\VerificationUserEmail;
use Illuminate\Support\Facades\Mail;
use App\Models\User;

class SendEmailVerificationUser extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:send-email-verification-user {id : The ID of the user)';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
	    //$id = $this->argument('id');
	    $userId = '1';
	    $user = User::find($userId);
	    if (!$user) {
	        $this->error('User not found.');
	        return;
	    } else {
		    // Send the email
		    Mail::to($user->email)->send(new VerificationUserEmail($user));
	
		    $this->info('Email sent successfully to ' . $user->email);
	   }
    }
}
