@include('header')

<?php function clean($string) {
	$string = str_replace(' ', '-', $string);
	$string = preg_replace('/[^A-Za-z0-9\-]/', '-', $string);
	return ltrim(str_replace('---','-',$string), '-');
} ?>

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/lawyer-page.css">

<script>
	var law_review = "{{ url('/') }}/add_lawyer_review";
	var law_contact = "{{ url('/') }}/contact_lawyer";
</script>
<script src="{{ url('/') }}/js/lawyer-page.js"></script>

<!-- Lawyer page breadcrumbs section html start -->
<section class="breadcrumbs-wapper">
	<div class="container w-1280">
		<div class="breadcrumbs-card">
			<div class="breadcrumbs-main">
				<div class="breadcrumbs-inner-text">
					<ul>
						<li><a href="{{ url('/') }}" title="Home">Home </a></li>
						<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
						<li><a href="{{ url('/') }}/lawyers" title="View More Lawyers">  Lawyers </a></li>
						<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>	
						<?php if(isset($state) && $state != ""){ ?>
							<li><a href="{{ url('/') }}/lawyers/pa/{{strtolower(str_replace(' ', '-', $p_area))}}/{{strtolower(str_replace(' ', '-', $state))}}" title="View More Lawyers in {{$state}}">{{$state}}</a></li>
							<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
						<?php } ?>
						<li>{{ $lawyer->prefix ? $lawyer->prefix . '.' : '' }} {{ $lawyer->first_name }} {{ $lawyer->middle_name ? $lawyer->middle_name . '.' : '' }}{{ $lawyer->last_name }}</li>
					</ul>
				</div>
			</div>
			<div class="claim-profile">
				<a href="{{ url('/') }}/lawyer-register?l_id={{$lawyer->id}}">Claim this profile</a>
			</div>
		</div>
	</div>
</section>
<!-- Lawyer page banner breadcrumbs html end -->

<!-- lawyer profile, Overview & Reviews section html start -->
<section class="lawyer-profile-wapper">
	<!-- lawyer profile section html start -->
	<div class="container w-1280">
		<div class="lawyer-profile-main">
			<div class="lawyer-profile-left">
				<div class="lawyer-profile-list-card premium-card-wapper">
					<input type="hidden" id="lawyer_id" value="{{$lawyer->id}}">
					<div class="lawyer-profile-list-left">
						@if($lawyer->featured)
						<div class="lawyer-profile-premium-list">
							<span>PREMIUM</span>
						</div>
						@endif

						<div class="lawyer-profile-list-thumb">
							<?php if(isset($lawyer->picture) && ($lawyer->picture != '')){ ?>
								<img src="{{$lawyer->picture}}" alt="">
							<?php }else{ ?>
								<img src="{{ url('/') }}/img/placeholder_image_white.svg" alt="">
							<?php } ?>
						</div>
						<div class="lawyer-profile-stars">
							<span class="lawyer-profile-stars-rating" rating="<?php echo $avg; ?>">
								<span class="star"></span>
								<span class="star"></span>
								<span class="star"></span>
								<span class="star"></span>
								<span class="star"></span>
							</span>
							<p><span class="l_tot_rev"><?php echo $total_reviews; ?></span> reviews</p>
						</div>
					</div>
					<div class="lawyer-profile-list-right">
						<div class="lawyer-profile-right-card">
							<h2>{{ $lawyer->prefix ? $lawyer->prefix : '' }} {{ $lawyer->first_name }} {{ $lawyer->middle_name ? $lawyer->middle_name : '' }}{{ $lawyer->last_name }}

								@if (isset($lawyer->firm->name) && ($lawyer->firm->name != '')) 
								- {{ $lawyer->firm->name }}</h2>
								@endif
							</h2>
							<h3>{{$p_area}} Lawyer Serving at {{$state}}</h3>

							@if($lawyer->address && $lawyer->address->isNotEmpty())
							<span class="address-card"><img src="{{ url('/') }}/img/location-icon.svg">
								@php
								$address = $lawyer->address->first();
								@endphp
								{{ $address->full_address}}, {{ $address->state }},  {{ $address->zipcode }}

							</span>
							@endif

							<ul>
								@if($lawyer->education && $lawyer->education->isNotEmpty())
								<li>
									<img src="{{ url('/') }}/img/graduation.svg" alt="">
									@php
									$education = $lawyer->education->first();
									@endphp
									{{ $education->institution }}
								</li>
								@endif 

								@if ($lawyer->practiceAreas && $lawyer->practiceAreas->isNotEmpty())
								<li>
									<img src="{{ url('/') }}/img/law-icon.svg" alt="">
									@php
									$total = $lawyer->practiceAreas->count();
									@endphp
									@foreach($lawyer->practiceAreas as $index => $practiceArea)
									@if($index == $total - 2 && $total > 1)
									{{ $practiceArea->name }}
									@elseif($index == $total - 1)
									and {{ $practiceArea->name }}
									@else
									{{ $practiceArea->name }},
									@endif
									@endforeach
								</li>
								@endif

								<li>
									<img src="{{ url('/') }}/img/experience-icon.svg" alt="">
									@if($lawyer->address && $lawyer->address->isNotEmpty())
									{{ $address->city }}, {{ $address->state }} 
									@endif

									{{$p_area}} Lawyer

									@if (isset($lawyer->experience_years))
									with {{ $lawyer->experience_years }} years of experience
									@endif
								</li>
							</ul>
						</div>
					</div>
				</div>
			</div>
			<div class="lawyer-profile-right">
				<div class="lawyer-profile-last">
					<div class="lawyer-profile-last-top">
						@if($lawyer->address && $lawyer->address->isNotEmpty())
						<span><img src="{{ url('/') }}/img/location-b.svg" alt=""><a href="#">{{ $address->full_address }}, {{ $address->city }}, {{ $address->state }}, {{ $address->zip_code }}</a></span>
						@endif

						<span><img src="{{ url('/') }}/img/phone-icon.svg" alt=""><a href="tel:+<?php echo clean($lawyer->phone); ?>"><?php echo $lawyer->phone; ?></a></span>
					</div>
					<div class="lawyer-profile-last-bottom">
						@if (isset($lawyer->url) && ($lawyer->url != ''))
						<a href="{{$lawyer->url}}" class="lawyer-profile-website-btn"><img src="{{ url('/') }}/img/web-icon.svg" alt=""> View Website </a>
						@endif

						@if (isset($lawyer->email) && ($lawyer->email != ''))
						<a href="" data-toggle="modal" data-target="#contact-form-modal" class="lawyer-profile-email-btn"><img src="{{ url('/') }}/img/email.svg" alt=""> Email Lawyer</a>
						@endif
					</div>
						<!-- 
						<ul class="lawyer-profile-social">
							<li><a href="#"><img src="{{ url('/') }}/img/Facebook.svg" alt=""></a></li>
							<li><a href="#"><img src="{{ url('/') }}/img/Twitter.svg" alt=""></a></li>
							<li><a href="#"><img src="{{ url('/') }}/img/LinkedIn.svg" alt=""></a></li>
							<li><a href="#"><img src="{{ url('/') }}/img/Twitter-2.svg" alt=""></a></li>
						</ul>
					-->
				</div>
			</div>
		</div>
	</div>
	<!-- lawyer profile section html end -->
</section>

<!-- lawyer Overview & Reviews section html start -->
<section class="lawyer-details-wapper">
	<div class="container w-1280">
		<div class="lawyer-d-tab-wapper">
			<div class="lawyer-overview-flex">
				<div class="lawyer-details-flex overview-width">
					<div class="lawyer-tab-menu">
						<ul>
							<li><a href="javascript:void(0)" class="lawyer-tab-a lawyer-active-a" data-id="overview">Overview</a></li>
							<li><a href="javascript:void(0)" class="lawyer-tab-a" data-id="reviews">Reviews <span class="l_tot_rev"><?php echo $total_reviews; ?></span></a></li>
						</ul>
					</div>

					<div class="lawyer-tab-container">
						<div class="lawyer-tab lawyer-tab-active" data-id="overview">
							<div class="lawyer-overview-details">
								<div class="lawyer-details-text-card">
									<div class="lawyer-details-text">
										<?php if($lawyer->description != ""){ ?>
											{!! $lawyer->description !!} 
											<a data-show="more" more-collapse="false" href="javascript:void(0)" class="showmore">Read More »</a></p>
										<?php } ?>
									</div>

									@if ($lawyer->language && $lawyer->language->isNotEmpty())
									<div class="languages-card">
										<h4>Languages:</h4>
										<ul>
											@foreach($lawyer->language as $ll)
											<li> {{ $ll->name }} </li>
											@endforeach
										</ul>
									</div>
									@endif
								</div>

								@if ($lawyer->practiceAreas && $lawyer->practiceAreas->isNotEmpty())
								<div class="practice-areas-card pt--48">
									<div class="lawyer-overview-sub-title">
										<h3><img src="{{ url('/') }}/img/Area-icon.svg" alt=""><span>Practice Areas</span></h3>
									</div>

									@foreach($lawyer->practiceAreas as $practiceArea)
									<div class="lawyer-overview-col">
										<h4>{{ $practiceArea->name }}</h4>
										<!-- <p>Brain Injury, Car Accidents, Motorcycle Accidents, Premises Liability, Truck Accidents, Wrongful Death</p> -->
									</div>
									@endforeach

								</div>
								@endif

								@if ($lawyer->fee && $lawyer->fee->isNotEmpty())
								<div class="fees-card pt--48">
									<div class="lawyer-overview-sub-title">
										<h3><img src="{{ url('/') }}/img/Fees-icon.svg" alt=""><span>Fees</span></h3>
									</div>
									@foreach($lawyer->fee as $lf)
									<div class="lawyer-overview-col">
										<h4>{{ $lf->name }}</h4>
									</div>
									@endforeach
								</div>
								@endif

								@if ($lawyer->professional_experience && $lawyer->professional_experience->isNotEmpty())
								<div class="professional-experience-card pt--48">
									<div class="lawyer-overview-sub-title">
										<h3><img src="{{ url('/') }}/img/professional-experience.svg" alt=""><span>Professional Experience</span></h3>
									</div>
									<div class="professional-experience-main">
										@foreach($lawyer->professional_experience as $lpe)
										<div class="professional-text">
											<div class="lawyer-overview-col">
												<h4>{{ $lpe->position }}</h4>
												<p>{{ $lpe->employer }}</p>
											</div>
											<div class="fees-btn">
												<a href="#">{{ $lpe->year_started }} - {{ $lpe->year_ended }}</a>
											</div>
										</div>
										@endforeach
									</div>
								</div>
								@endif

								@if ($lawyer->jurisdiction && $lawyer->jurisdiction->isNotEmpty())
								<div class="professional-experience-card pt--48">
									<div class="lawyer-overview-sub-title">
										<h3><img src="{{ url('/') }}/img/professional-experience.svg" alt=""><span>Jurisdictions</span></h3>
									</div>
									<div class="professional-experience-main">
										@foreach($lawyer->jurisdiction as $ljd)
										<div class="professional-text">
											<div class="lawyer-overview-col">
												<h4>{{ $ljd->name }}</h4>
											</div>
											@if ($ljd->since && $ljd->since != "")
											<div class="fees-btn">
												<a href="#">{{$ljd->since}} - Current</a>
											</div>
											@endif
										</div>
										@endforeach
									</div>
								</div>
								@endif

								@if ($lawyer->education && $lawyer->education->isNotEmpty())
								<div class="education-card pt--48">
									<div class="lawyer-overview-sub-title">
										<h3><img src="{{ url('/') }}/img/Education-icon.svg" alt=""><span>Education</span></h3>
									</div>
									<div class="professional-experience-main">
										@foreach($lawyer->education as $led)
										<div class="professional-text">
											<div class="lawyer-overview-col">
												<h4>{{ $led->institution }}</h4>
												<p>{{ $led->title }}</p>
											</div>
											<div class="fees-btn">
												<a href="#">{{ $led->year_started }} - {{ $led->year_ended }}</a>
											</div>
										</div>
										@endforeach
									</div>
								</div>
								@endif

								@if ($lawyer->award && $lawyer->award->isNotEmpty())
								<div class="awards-card pt--48">
									<div class="lawyer-overview-sub-title">
										<h3><img src="{{ url('/') }}/img/awards-icon.svg" alt=""><span>Awards</span></h3>
									</div>
									@foreach($lawyer->award as $law)
									<div class="lawyer-overview-col">
										<h4>{{ $led->name }}</h4>
										<p>{{ $led->organization }}</p>
									</div>
									@endforeach
								</div>
								@endif

							</div>
						</div>

						<div class="lawyer-tab" data-id="reviews">
							<div class="lawyer-write-review">
								<p>Be the first to share your experience! Your insights could greatly help others in need of legal assistance.</p>
								<?php if(Session::has('f_user_login')){
									if(Session::get('f_user_login') == 1){ ?>
										<a href="javascript:void(0)" data-toggle="modal" data-target="#write-review-modal" >Write review</a>
									<?php }  
								}else{ ?>
									<a href="javascript:void(0)" data-toggle="modal" data-target="#login-form-modal" >Write review</a>
									<?php 
								} ?>
							</div>

							<div class="lawyer-reviews-details">
								<div class="lawyer-reviews-row">
									<?php if($reviews->count() > 0){
										foreach($reviews as $rev){
											$user = DB::table('users')->where('id', $rev->user_id)->first(); ?>
											<div class="lawyer-reviews-col">
												<div class="lawyer-reviews-card">
													<!-- <h3>Auto accident</h3> -->
													<p><?php echo $rev->comment; ?></p>
													<div class="lawyer-reviews-bottom">
														<h4><?php if(isset($user->name)){echo $user->name;} ?></h4>
														<span class="lawyer-reviews-stars-rating" rating="<?php echo $rev->rating; ?>">
															<span class="star"></span>
															<span class="star"></span>
															<span class="star"></span>
															<span class="star"></span>
															<span class="star"></span>
														</span>
													</div>
												</div>
											</div>
										<?php } 
									} ?>
								</div>
							</div>
						</div>
					</div>
				</div>

				<?php $si=1;if(!empty($similar)){  ?>
					<div class="lawyer-sln-wapper sln-active">
						<h3 class="sln-title">Similar lawyers nearby</h3>
						<div class="sln-card-wapper">

							<?php foreach($similar as $sim){
								if($si < 3){
									if($sim->address && $sim->address->isNotEmpty()){
										$saddress = $sim->address->first();
									}

									if($saddress->state == $address->state || $saddress->city == $address->city || $sim->featured != 1){
										$l_name = ($sim->prefix ? $sim->prefix . '.' : '').' '.$sim->first_name.' '.($sim->middle_name ? $sim->middle_name : '' ).' '.$sim->last_name;
										$l_url = strtolower(($sim->prefix ? $sim->prefix . '-' : '').$sim->first_name.'-'.($sim->middle_name ? $sim->middle_name.'-' : '' ).$sim->last_name);

										$reviews = DB::table('listing_reviews')->where('listing_id', $sim->id)->get();
										$avg = 0;
										$total_reviews = $reviews->count();
										if($reviews->count() > 0){
											$avg = ceil($reviews->sum('rating')/$total_reviews);
										}

										if(!isset($p_area) || $p_area == ""){
											if($lawyer->practiceAreas->count() > 0){
												$p_area = $lawyer->practiceAreas->first()->name;
											}else{
												continue;
											}
										}

										if(!isset($state) || $state == ""){
											if($saddress){
												$state = $saddress->state;
											}else{
												continue;
											}
										} ?>

										<div class="sln-card-box-wapper sln-premium-card">
											<div class="sln-list-top">
												<div class="sln-premium-list">
													<span>PREMIUM</span>
												</div>
												<div class="sln-list-thumb">
													<img src="{{ url('/') }}/img/default_lawyer_2.png" alt="">
												</div>
												<div class="sln-content-stars">
													<span class="sln-content-stars-rating" rating="<?php echo $avg; ?>">
														<span class="star"></span>
														<span class="star"></span>
														<span class="star"></span>
														<span class="star"></span>
														<span class="star"></span>
													</span>
													<p><?php echo $total_reviews; ?> reviews</p>
												</div>
											</div>
											<div class="sln-bottom-card">
												<h2><a href="{{ url('/') }}/lawyer/{{ str_replace(' ','-',$l_url) }}-{{ $sim->id }}"><?php echo $l_name; ?></a></h2>
												<h3>{{ $p_area }} Lawyer Serving at {{ $address->city.' - ' }} {{ $state }}</h3>
												<div class="sln-center-bottom">
													<!-- <span><img src="{{ url('/') }}/img/check-icon.svg" alt="">Free Consultation</span> -->
													<span>
														<i class="fas fa-phone-alt"></i>
														<a href="tel:+<?php echo clean($sim->phone); ?>"><?php echo clean($sim->phone); ?></a>
													</span>
												</div>
												<a href="{{ url('/') }}/lawyer/{{ str_replace(' ','-',$l_url) }}-{{ $sim->id }}" class="sln-view-profile">View Profile</a>
											</div>
										</div>
										<?php $si++;
									}
								}
							} ?>

						</div>
					</div>
				<?php } ?>

			</div>
		</div>
	</div>
</section>
<!-- lawyer Overview & Reviews section html end -->

<?php if(Session::has('f_user_login')){
	if(Session::get('f_user_login') == 1){ ?>
		<!-- Write review modal popup html start -->
		<div class="modal fade write-review-modal" id="write-review-modal" tabindex="-1" aria-labelledby="write-review-popup" aria-hidden="true">
			<div class="modal-dialog modal-dialog-centered">
				<div class="modal-content">
					<div class="modal-body">
						<div class="lawyer-pofile-modal">
							<div class="lawyer-pofile-img">
								<?php if(isset($lawyer->picture) && ($lawyer->picture != '')){ ?>
									<img src="{{$lawyer->picture}}" alt="">
								<?php }else{ ?>
									<img src="{{ url('/') }}/img/default_lawyer_2.png" alt="">
								<?php } ?>
							</div>

							<h2>Write the review about {{ $lawyer->prefix ? $lawyer->prefix . '.' : '' }} {{ $lawyer->first_name }} {{ $lawyer->middle_name ? $lawyer->middle_name . '.' : '' }}{{ $lawyer->last_name }}</h2>
						</div>
						<form method="post" action="" class="write-review-form-main">
							<div class="form-group">
								<div class="write-review-title">Write a Review</div>
								<textarea rows="4" name="" id="l_rev_comment"></textarea>
							</div>
							<div class="write-review--card">
								<div class="write-review-title">User Rating</div>
								<input type="hidden" id="l_rev_list_id" value="{{$lawyer->id}}">
								<input type="hidden" id="l_rev_usr_id" value="{{Session::get('user_id')}}">
								<input type="hidden" id="l_rev_rating" value="">
								<div class="input-stars big-stars">
									<div class="rating-stars">
										<ul id="stars" class="stars-card">
											<li class="star" data-value="1">
												<i class="fas fa-star"></i>
											</li>
											<li class="star" data-value="2">
												<i class="fas fa-star"></i>
											</li>
											<li class="star" data-value="3">
												<i class="fas fa-star"></i>
											</li>
											<li class="star" data-value="4">
												<i class="fas fa-star"></i>
											</li>
											<li class="star" data-value="5">
												<i class="fas fa-star"></i>
											</li>
										</ul>
									</div>
								</div>
							</div>
							<div class="submit-btn-w">
								<span class="l_rev_err"></span>
								<button id="l_rev_submit">Submit</button>
								<span class="l_rev_success"></span>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
		<!-- Write review modal popup html end -->
	<?php } 
} ?>


<!-- lawyer profile, Overview & Reviews section html end -->
<div class="lawyer-profile-bottom">
	<div class="lawyer-profile-bottom-v">
		<span>View contacts</span><img src="{{ url('/') }}/img/down-arrow.svg" alt="">
	</div>
	<div class="lawyer-profile-right">
		<div class="lawyer-profile-last">
			<div class="lawyer-profile-last-top">
				@if($lawyer->address && $lawyer->address->isNotEmpty())
				<span><img src="{{ url('/') }}/img/location-b.svg" alt=""><a href="#">{{ $address->full_address }}, {{ $address->city }}, {{ $address->state }}, {{ $address->zip_code }}</a></span>
				@endif

				<span><img src="{{ url('/') }}/img/phone-icon.svg" alt=""><a href="tel:+<?php echo clean($lawyer->phone); ?>">{{$lawyer->phone}}</a></span>
			</div>
			<div class="lawyer-profile-last-bottom">
				@if (isset($lawyer->url) && ($lawyer->url != ''))
				<a href="{{$lawyer->url}}" class="lawyer-profile-website-btn"><img src="{{ url('/') }}/img/web-icon.svg" alt=""> View Website </a>
				@endif

				@if (isset($lawyer->email) && ($lawyer->email != ''))
				<a href="#" data-toggle="modal" data-target="#contact-form-modal" class="lawyer-profile-email-btn"><img src="{{ url('/') }}/img/email.svg" alt=""> Email Lawyer</a>
				@endif
			</div>
			<ul class="lawyer-profile-social">
				<li><a href="#"><img src="{{ url('/') }}/img/Facebook.svg" alt=""></a></li>
				<li><a href="#"><img src="{{ url('/') }}/img/Twitter.svg" alt=""></a></li>
				<li><a href="#"><img src="{{ url('/') }}/img/LinkedIn.svg" alt=""></a></li>
				<li><a href="#"><img src="{{ url('/') }}/img/Twitter-2.svg" alt=""></a></li>
			</ul>
		</div>
	</div>
</div>


@include('footer')

