<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\GlossaryRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class GlossaryCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class GlossaryCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     * 
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Glossary::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/glossary');
        CRUD::setEntityNameStrings('glossary', 'glossaries');

    }

    /**
     * Define what happens when the List operation is loaded.
     * 
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {
        if (! $this->crud->getRequest()->has('order')){
       		$this->crud->orderBy('name', 'desc');
    	}

        // Columns to be shown in the list view
        $this->crud->addColumn([
            'name' => 'name',
            'type' => 'text',
            'label' => 'Word'
        ]);
        
        // If the definition is also to be shown in the list, add its column as well
        $this->crud->addColumn([
            'name' => 'definition',
            'type' => 'text',
            'label' => 'Definition',
            'wrapper' => [
                'class' => 'col-md-6',
            ],
        ]);
	CRUD::enableExportButtons();
    }
    /**
     * Define what happens when the Create operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {

//        $this->crud->setValidation(GlossaryRequest::class);

        // Fields to be shown in the create view
        $this->crud->addField([
            'name' => 'name',
            'type' => 'text',
            'label' => 'Word'
        ]);

        $this->crud->addField([
            'name' => 'definition',
            'type' => 'textarea',
            'label' => 'Definition'
        ]);
    }

    /**
     * Define what happens when the Update operation is loaded.
     * 
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
    protected function setupShowOperation()
    {
        $this->crud->set('show.setFromDb', false);

        // Columns to be shown in the show view
        $this->crud->addColumn([
            'name' => 'name',
            'type' => 'text',
            'label' => 'Word'
        ]);
        
        $this->crud->addColumn([
            'name' => 'definition',
            'type' => 'textarea',
            'label' => 'Definition'
        ]);
    }
}
