$(function () {
    $(".error").fadeOut();

    function errorFadeIn(text) {
        $(".error").fadeIn();
        jQuery(".error").css("color", "#2D4E66");
        jQuery(".error").text(text);
        setTimeout(() => {
            $(".error").fadeOut();
        }, 3000);
        return false;
    }

    function errorFadeOut() {
        $(".error").fadeOut();
        jQuery(".error").css("color", "#fff");
        jQuery(".error").text("");
    }

    // select dropdown js
    jQuery(".support-drop-down .support-selected a").click(function() {
        jQuery(this).toggleClass('selected-a');
        jQuery(".support-drop-down .support-options").toggle();
    });
    jQuery(".support-drop-down .support-options ul li a").click(function() {
        var text = jQuery(this).attr('value');
        jQuery(".support-drop-down .support-options ul li a").removeClass('select-value');
        jQuery(this).addClass('select-value');
        jQuery(this).parent().parent().parent().parent().find('.support-selected a span').html(jQuery(this).text());
        jQuery(".support-drop-down .support-options").hide();
    }); 
    jQuery(document).bind('click', function(e) {
        var jQueryclicked = jQuery(e.target);
        if (! jQueryclicked.parents().hasClass("support-drop-down"))
            jQuery(".support-drop-down .support-options").hide();
    });

    // contact form submit
    $("#contact_submit").click(function (e) {
        e.preventDefault();
        $("#contact_form").submit();
    });

    $("#contact_form").submit(function (e) {
        e.preventDefault();

        var first_name = $("#first_name").val();
        var last_name = $("#last_name").val();
        var contact = $("#contact").val();
        var zip = $("#zip").val();
        var summary = $("#contact_summary").val();
        var con_emails = $(".support-options .select-value");
        // var filter = /^([\w-\.]+)@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([\w-]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\]?)$/;

        if (first_name.length == 0 || first_name.length < 3) {
            errorFadeIn("Enter valid first name. It should be 3 character long");
        } else if (last_name.length == 0 || last_name.length < 3) {
            errorFadeIn("Enter valid last name. It should be 3 character long");
        } else if (contact.length == 0) {
            errorFadeIn("Enter valid Email/Phone");
        } else if (zip.length == 0 || zip.length < 3) {
            errorFadeIn("Please enter valid zip code");
        } else if (summary.length == 0) {
            errorFadeIn("Please enter Summary");
        }else if (con_emails.length == 0) {
            errorFadeIn("Please select Department");
        }  else {
            errorFadeOut(".error");
            const formData = new FormData();
            formData.append("first_name", $("#first_name").val());
            formData.append("last_name", $("#last_name").val());
            formData.append("contact", $("#contact").val());
            formData.append("zip", $("#zip").val());
            formData.append("summary", $("#contact_summary").val());
            formData.append("con_emails", $(".support-options .select-value").attr("value"));

            if(grecaptcha.getResponse(widgetId1) != ""){
                ajaxSend(formData, contactURL);
            }else{
                errorFadeIn("Captcha Failed");
            }
        }
    });

    function ajaxSend(data, url) {
        $.ajaxSetup({
            headers: { "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content") },
        });
        $("#contact_submit").html('<i class="fas fa-spinner fa-pulse"></i>');
        $("#contact_submit").attr("disabled", true);
        $.ajax({
            url: url,
            type: "POST",
            data: data,
            processData: false,
            contentType: false,
            success: function (response) {
                var response = JSON.parse(response);
                $(".error").text(response.success);
                $(".error").fadeIn();
                jQuery(".error").css("color", "#2D4E66");
                $("#contact_submit").html("Submit");
                $("#contact_submit").attr("disabled", false);
                document.getElementById("contact_form").reset();
                setTimeout(() => {
                    $(".error").fadeOut();
                    $(".error").text("");
                }, 5000);
            },
        });
    }
});