@include('header')

@php
$location = "";
if(isset($city) && $city != ""){
	$location .= $city.", ";
}
$location .= $state;
@endphp

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/practice-area-state-page.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/lawyer_list_template.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/css/toc.css">

<!-- listing page banner section html start -->
<section class="listing-banner-wapper">
	<div class="container w-1280">
		<div class="listing-banner-main">
			<div class="breadcrumbs-inner-text">
				<ul>
					<li><a href="{{ url('/') }}">Home </a></li>
					<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<li><a href="{{ url('/') }}/lawyers">  Lawyers Directory </a></li>
					<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<li><a href="{{ url('/') }}/lawyers/pa/{{ $p_area_data->slug }}">{{$p_area}}</a></li>
					<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<li><a href="{{ url('/') }}/lawyers/pa/{{ $p_area_data->slug }}/{{strtolower(str_replace(' ', '-', $state))}}">{{$state}}</a></li>
					<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<?php if(isset($city) && $city != ""){
						$city_url = strtolower(str_replace(' ', '-', str_replace('.', '', $city))); ?>

						<li><a href="{{ url('/') }}/lawyers/pa/{{strtolower(str_replace(' ', '-', $p_area))}}/{{strtolower(str_replace(' ', '-', $state))}}/{{$city_url}}">{{$city}}</a></li>
						<li><img src="{{ url('/') }}/img/right-icon.svg" alt=""></li>
					<?php } ?>
					<li>Attorneys</li>
				</ul>
			</div>
			<div class="listing-title">
				<h1><?php echo "Best ".$p_area." Lawyers in ".$location; ?></h1>
				<?php if(!empty($content)){ ?>
					<p><?php echo preg_replace('/ style=("|\')(.*?)("|\')/','', $content->short_content); ?></p>
				<?php }else{ ?>
					<p><?php echo "Find the leading ".$p_area." lawyers in ".$location." at Legal.com. Our list features attorneys who are well-versed in ".$location."'s legal landscape, specializing in ".$p_area." cases. They are committed to protecting your rights and ensuring the best possible results."; ?></p>
				<?php } ?>
			</div>
			<?php if(isset($content->h2_after_s_c) && $content->h2_after_s_c != ""){ ?>
				<div class="banner-title-h2">
					<h2><?php echo $content->h2_after_s_c; ?></h2>
				</div>
			<?php }else{ ?>
				<div class="banner-title-h2">
					<h2><?php echo "Find the Best ".$p_area." Attorney in ".$location; ?></h2>
				</div>
			<?php } ?>
			@include('templates/top_filter')
		</div>
	</div>
</section>
<!-- listing page banner section html start -->

<!-- Lawyers list section html start -->
<?php if($lawyers->count() > 0){ ?>
	<input type="hidden" id="p_area" value="{{$p_area}}">
	<input type="hidden" id="state" value="{{$state}}">
	<input type="hidden" id="city" value="{{$city}}">

	<section class="lawyers-list-wapper">
		<div class="lawyers-top-shape">
			<div class="container w-1280">

				<div class="row">
					<div class="col-12 col-lg-3">
						<div class="lawyers-sidebar-wapper">
							<div class="lawyers-sidebar-title">
								<h3>Filter Results</h3>
								<a href="#">Clear all</a>
							</div>
							<div class="lawyers-sidebar-card">
								<div class="lawyers-rating-card">
									<h3>Rating</h3>
									<div class="form-p-wapper">
										<div class="form-check">
											<input class="radio" type="radio" value="5star" name="star" id="5" checked="">
											<label for="5"><img src="{{ url('/') }}/img/5-star.png" alt=""></label>
										</div>
										<div class="form-check">
											<input class="radio" type="radio" value="4star" name="star" id="4">
											<label for="4"><img src="{{ url('/') }}/img/4-star.png" alt=""></label>
										</div>
										<div class="form-check">
											<input class="radio" type="radio" value="3star" name="star" id="3">
											<label for="3"><img src="{{ url('/') }}/img/3-star.png" alt=""></label>
										</div>
										<div class="form-check">
											<input class="radio" type="radio" value="2star" name="star" id="2">
											<label for="2"><img src="{{ url('/') }}/img/2-star.png" alt=""></label>
										</div>
										<div class="form-check">
											<input class="radio" type="radio" value="1star" name="star" id="1">
											<label for="1"><img src="{{ url('/') }}/img/1-star.png" alt=""></label>
										</div>
									</div>
								</div>
								<div class="lawyers-rating-card">
									<h3>Language</h3>
									<div class="lawyers-language">
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" checked="" id="English">
											<label class="form-check-label" for="English">English</label>
										</div>
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" id="Spanish">
											<label class="form-check-label" for="Spanish">Spanish</label>
										</div>
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" id="Portuguese">
											<label class="form-check-label" for="Portuguese">Portuguese</label>
										</div>
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" id="Сhinese">
											<label class="form-check-label" for="Сhinese">Сhinese</label>
										</div>
									</div>
								</div>
								<div class="lawyers-rating-card">
									<h3>Features</h3>
									<div class="lawyers-language">
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" checked="" id="Offers free consultation">
											<label class="form-check-label" for="Offers free consultation">Offers free consultation</label>
										</div>
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" id="Offers virtual appointments">
											<label class="form-check-label" for="Offers virtual appointments">Offers virtual appointments</label>
										</div>
										<div class="lawyers-form-check">
											<input class="form-check-input" type="checkbox" value="" id="Accepts credit cards">
											<label class="form-check-label" for="Accepts credit cards">Accepts credit cards</label>
										</div>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-12 col-lg-9">
						<div class="lawyers-list-main">
							@include('lawyers/lawyers_pagination')
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
<?php }else{ ?>
	<section class="lawyers-list-wapper">
		<div class="lawyers-top-shape">
			<div class="container w-1280">
				<p>We are still evaluating lawyers to feature in this directory. In the meantime, consider expanding your search to a wider area.</p>
			</div>
		</div>
	</section>
<?php } ?>
<!-- Lawyers list section html end -->

<!-- Legal Guides section start -->
<div class="lelgal-guides-section">
	<div class="container w-1280">
		<div class="row">

			<?php if(!empty($content) && !empty($content->full_content != "")){ ?>
				<div class="col-12 col-lg-3">
					<div class="right-sidebar-wapper" id="sidebar-Wrap1">
						<div class="side-bar-overflow1">
							<span class="sidebar-toc-heading">Table of content</span>
							<ul class="sidebar-text sidebar-ul"></ul>
						</div>
					</div>
				</div>
			<?php } ?>

			<div class="col-12 col-lg-9">
				<?php if(!empty($content)){ ?>
					<div class="learn-about-wapper">
						<?php if($content->full_content != ""){ ?>
							<div class="learn-about-text">
								<!-- <h2>Learn About the Law</h2> -->
								<?php echo preg_replace('/ style=("|\')(.*?)("|\')/','', $content->full_content); ?>
							</div>
						<?php } ?>

						<?php 
						if(!empty($cdata)){
							if($cdata->faqs != ""){ 
								$faqs = $cdata->faqs;

								if(!empty($faqs)){ ?>

									<?php if(isset($cdata->faqs_title) && $cdata->faqs_title != ""){ ?>
										<h2 class="mt-5"><?php echo $cdata->faqs_title; ?></h2>
									<?php } ?>

									<div class="review-faq-wapper">
										<div class="faq-accordion-wapper">
											<?php foreach($faqs as $faq){ ?>
												<div class="faq-accordion-item">
													<div class="d-flex align-items-baseline faq-menu">
														<a href="javascript:void(0)"><?php echo $faq->faq_title; ?></a>
													</div>
													<div class="faq-content" style="">
														<p><?php echo $faq->faq_description; ?></p>
													</div>
												</div>
											<?php } ?>
										</div>
									</div>
								<?php }	
							}
						} ?>
					</div>
				<?php } ?>

				<div class="Legal-Guides-wapper" style="display:none;">
					<h2>Legal Research and <span>Law Practice</span></h2>
					<div class="injured-law-wapper legal-research-card">
						<?php 
						$p_areas = $data['p_areas'];

						if(!empty($p_areas)){
							foreach($p_areas as $p_a){ ?>
								<div class="Injury-Law-card-wapper">
									<h6><a href="{{ url('/') }}/lawyers/{{ $p_a['slug'] }}"><?php echo $p_a['name']; ?></a></h6>
								</div>
							<?php } 
						}else{ ?>
							<p class="text-center">No Data Found</p>
						<?php } ?>
					</div>
					<div class="read-more-btn">
						<a href="javascript:void(0)" id="legal-research-card">Load more</a>
					</div>
				</div>
			</div>

			<?php if(!empty($content) && !empty($content->full_content != "")){ ?>
				<!-- mobile view toc button start -->
				<div class="mobile-view-toc-wapper">
					<div class="right-sidebar-wapper" id="m-sidebar-Wrap1">
						<div class="side-bar-overflow1">
							<span class="sidebar-toc-heading">Table of content</span>
							<ul class="sidebar-text sidebar-ul"></ul>
						</div>
					</div>
					<button class="m-view-toc-btn">Menu</button>
				</div>
				<!-- mobile view toc button end -->
			<?php } ?>
			
		</div>
	</div>
</div>
<!-- Legal Guides section end -->

<script>
	var state_paginate = "{{ url('/') }}/lawyers_pagination";
</script>
<script src="{{ url('/') }}/js/practice-area-state-page.js"></script>
<script src="{{ url('/') }}/js/toc.js"></script>

@include('footer')
