@extends(backpack_view('layouts.plain'))

@section('content')

<div class="row justify-content-center align-items-center d-flex flex-row min-vh-100">
    <div class="col-12 col-md-8 col-lg-6">
        <h3 class="text-center mb-4">{{ trans('backpack::base.verify_email.email_verification') }}</h3>
        <div class="card mb-0">
            <div class="card-body">
            {{ trans('backpack::base.verify_email.email_verification_required') }}

            @if (session('status') == 'verification-link-sent')
                <div class="mt-3">
                    <div class="alert alert-success my-0" role="alert">
                        <div class="d-flex">
                        <div>
                            <svg xmlns="http://www.w3.org/2000/svg" class="icon alert-icon" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round"><path stroke="none" d="M0 0h24v24H0z" fill="none"></path><path d="M5 12l5 5l10 -10"></path></svg>
                        </div>
                            <div>
                                {{ trans('backpack::base.verify_email.verification_link_sent') }}
                            </div>
                        </div>
                    </div>
                </div>
            @endif
            </div>
            <div class="card-footer d-flex">
            @if (session('status') !== 'verification-link-sent')
            <form method="POST" class="col-md-6" action="{{ route('verification.send') }}">
                @csrf
                <button type="submit" class="btn btn-sm btn-primary float-start float-left" tabindex="6">{{ trans('backpack::base.verify_email.resend_verification_link') }}</button>   
            </form>
            @endif
            <form method="POST" class="col-md-6" action="{{ backpack_url('logout') }}">
                @csrf
                <button type="submit" class="btn btn-sm button-secondary float-end float-right" tabindex="7"><i class="la la-lock me-2"></i>{{ trans('backpack::base.logout') }}</button>   
            </form>     
            </div>       
        </div>
    </div>
</div>
@endsection