<?php echo $__env->make('shortcode', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('referral', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!DOCTYPE html>
<html>
<?php 
$pg_index = "no";$noindex_follow = "";
if(isset($page->extras)){
    if(isset($page->extras['url_index']) && $page->extras['url_index'] == 'yes'){
        $pg_index = "yes";
    }
}
if(isset($page->template) && $page->template == "all_practice_areas"){
    $noindex_follow = "yes";
}

if(isset($page->url_index)){
    if($page->url_index == 'yes'){
        $pg_index = "yes";
    }
} ?>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    
    <?php if(isset($page->title)): ?>
    <title><?php echo e($page->title); ?></title>
    <?php endif; ?>
    <?php if(isset($page->extras['meta_title'])): ?>
    <meta name="title" content="<?php echo e($page->extras['meta_title']); ?>" />
    <?php endif; ?>
    <?php if(isset($page->extras['meta_keywords'])): ?>
    <meta name="keywords" content="<?php echo e($page->extras['meta_keywords']); ?>" />
    <?php endif; ?>
    <?php if(isset($page->extras['meta_description'])): ?>
    <meta name="description" content="<?php echo e($page->extras['meta_description']); ?>" />
    <?php endif; ?>

    <meta property="og:image" content="<?php echo e(url('/')); ?>/img/share_legaldotcom.png" />

    <?php if($pg_index == "yes"){ ?>         
        <meta name="robots" content="index,follow" />
    <?php }elseif($noindex_follow){ ?>
        <meta name="robots" content="noindex,follow" />
    <?php }else{ ?>
        <meta name="robots" content="noindex,nofollow" />
    <?php } ?>

    <meta name="revisit-after" content="7 days">

    <?php if(isset($schema)): ?>
    <script type="application/ld+json">
        <?php echo $schema; ?>

    </script>
    <?php endif; ?>

    <meta name="coverage" content="Worldwide">
    <meta name="distribution" content="Global">
    <meta name="url" content="<?php echo e(request()->fullUrl()); ?>">
    <?php if(isset($pageArray->og_image)): ?>
    <meta name="og_image" content="<?php echo e(asset('storage/' . $page->og_image)); ?>"/>
    <meta name="og_secureImage" content="<?php echo e(asset('storage/' . $page->og_image)); ?>"/>
    <meta name="og_imageAlt" content="<?php echo e($page->og_imageAlt); ?>"/>
    <meta name="og_imageType" content="<?php echo e($page->og_imageType); ?>"/>
    <?php endif; ?>
    <meta name="rating" content="General">
    <?php if(isset($page->extras['meta_title'])): ?>
    <meta property="og:title" content="<?php echo e($page->extras['meta_title']); ?>"/>
    <?php endif; ?>
    <?php if(isset($page->meta_description)): ?>
    <meta property="og:description" content="<?php echo e($page->extras['meta_description']); ?>"/>
    <?php endif; ?>
    <?php if(isset($page->og_type)): ?>
    <meta property="og:type" content="<?php echo e($page->og_type); ?>"/>
    <?php endif; ?>
    <meta property="og:locale" content="en_us" />
    <meta property="og:url" content="<?php echo e(request()->fullUrl()); ?>"/>
    <meta name="twitter:card" content="summary"/>
    <link rel="canonical" href="<?php echo e(url()->current()); ?>" />

    <link rel="shortcut icon" href="<?php echo e(url('/')); ?>/img/favicon.png">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css"
    integrity="sha512-iBBXm8fW90+nuLcSKlbmrPcLa0OT92xO1BIsZ+ywDWZCvqsWgccV3gFoRBv0z+8dLJgyAHIhR35VZc2oM/gI1w=="
    crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link
    href="https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:ital,wght@0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,200;1,300;1,400;1,500;1,600;1,700;1,800&display=swap"
    rel="stylesheet">

    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
    integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/css/header-footer.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.0/jquery.min.js"
    integrity="sha512-3gJwYpMe3QewGELv8k/BX9vcqhryRdzRMxVfq6ngyWXwo03GFEzjsUm8Q7RZcHPHksttq7/GFoxjCVUjkjvPdw=="
    crossorigin="anonymous" referrerpolicy="no-referrer"></script>
    <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js"
    integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>

    <script> var login = "<?php echo e(url('/')); ?>/login"; </script>
    <script> var h_search = "<?php echo e(url('/')); ?>/header_search"; </script>
    <script> var r_verify = "<?php echo e(url('/')); ?>/resend_email_verification"; </script>
    <script src="<?php echo e(url('/')); ?>/js/header-footer.js"></script>

    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-Y2CWDLFXHX"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());

      gtag('config', 'G-Y2CWDLFXHX');
  </script>

<!-- Hotjar Tracking Code for Legal.com -->
<script>
    (function(h,o,t,j,a,r){
        h.hj=h.hj||function(){(h.hj.q=h.hj.q||[]).push(arguments)};
        h._hjSettings={hjid:3806340,hjsv:6};
        a=o.getElementsByTagName('head')[0];
        r=o.createElement('script');r.async=1;
        r.src=t+h._hjSettings.hjid+j+h._hjSettings.hjsv;
        a.appendChild(r);
    })(window,document,'https://static.hotjar.com/c/hotjar-','.js?sv=');
</script>
</head>


<body>
    <div class="m-overlay-bg"></div>
    <!-- header start -->
    <header id="h-home" class="h-home-wapper">
        <div class="h-header-main">
            <div class="container w-1280">
                 <div class="h-header-nav">
                    <div class="h-header-logo">
                        <a href="/"><img src="<?php echo e(url('/')); ?>/img/header-footer-img/Logo.svg" class="img-fluid"
                            alt="logo"></a>
                        </div>
                        <div class="h-header-menu">
                            <div class="h-toggle-btn" id="h-toggle-btn">
                                <div class="line-card one"></div>
                                <div class="line-card two"></div>
                                <div class="line-card three"></div>
                            </div>
                            <div class="h-main-menu" id="h-sidebar-wrapper">
                                <div>
                                    <ul>
                                        <li><a href="<?php echo e(url('/')); ?>/lawyers">Find a Lawyer</a></li>
                                        <li><a href="<?php echo e(url('/')); ?>/glossary-of-legal-terms">Glossary</a></li>
                                        <li><a href="<?php echo e(url('/')); ?>/about-us">About Us</a></li>
                                        <li><a href="<?php echo e(url('/')); ?>/contact">Contact Us</a></li>
                                    </ul>
                                </div>
                                <div class="Search-Button-Sign-Up-wapper mt-4 d-flex d-lg-none">
                                    <?php if(Session::has('f_user_login')){ ?>
                                        <a href="<?php echo e(url('/')); ?>/my-account" class="login-btn">
                                            <img src="<?php echo e(url('/')); ?>/img/user-acc-icon.svg" alt=""><?php echo Session::get('username'); ?>
                                        </a>
                                        <a href="<?php echo e(url('/')); ?>/logout" class="login-btn"> Logout </a>
                                    <?php }else{ ?>
                                        <a href="javascript:void(0)" class="login-btn modal-form-a" data-target="#login-form-modal">
                                            Log In
                                        </a>
                                        <a href="<?php echo e(url('/')); ?>/register" class="sign-up-btn modal-form-a">Sign Up</a>
                                    <?php } ?>
                                </div>
                            </div>
                        </div>
                        <div class="Search-Button-Sign-Up-wapper">
                            <div class="search-box">
                                <a href="javascript:void(0)" class="search-btn">
                                    <img src="<?php echo e(url('/')); ?>/img/header-footer-img/h-search-icon.svg" class="search-w" alt="">
                                    <img src="<?php echo e(url('/')); ?>/img/search-black-icon.svg" class="search-b" alt="">
                                </a>
                            </div>

                            <?php if(Session::has('f_user_login')){ ?>

                                <li class="nav-item dropdown login-btn d-none d-lg-flex">
                                    <a class="nav-link dropdown-toggle" href="javascript:void(0)" data-bs-toggle="dropdown">
                                        <img src="<?php echo e(url('/')); ?>/img/user-acc-icon.svg" alt=""><?php echo Session::get('username'); ?> 
                                    </a>
                                    <ul class="dropdown-menu">
                                        <li><a class="dropdown-item" href="<?php echo e(url('/')); ?>/my-account"> Edit Profile</a></li>
                                        <li><a class="dropdown-item" href="<?php echo e(url('/')); ?>/logout"> Logout </a></li>
                                    </ul>
                                </li>
                                
                            <?php }else{ ?>
                                <a href="javascript:void(0)" class="login-btn modal-form-a d-none d-lg-flex" data-target="#login-form-modal">
                                    Log In
                                </a>
                                <a href="<?php echo e(url('/')); ?>/register" class="sign-up-btn modal-form-a d-none d-lg-flex">Sign Up</a>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
            <!-- search html start  -->
            <div class="search-popup header_search">
                <span class="search-back-drop"></span>
                <button class="close-search"><span class="fas fa-times"></span></button>
                <div class="search-inner">
                    <form method="get" action="<?php echo e(url('/')); ?>" autocomplete="off">
                        <div class="form-group mb-0">
                            <input type="search" name="search" value="" placeholder="Search...">
                            <input type="hidden" id="h_search_type" name="search_type" value="">
                            <button type="submit"><i class="fa fa-search"></i></button>
                        </div>
                        <div class="p_search_results" style="display:none;">
                            <div class="ts-search-sub">
                                <div class="ts-header-card">
                                    <a class="ts-search--header ts-search--header-active" name="all">All</a>
                                    <a class="ts-search--header" name="lawyer">Lawyers</a>
                                    <a class="ts-search--header" name="glossary">Glossary</a>
                                </div>

                                <p class="p_search_loader" style="display: none;">
                                    <img src="<?php echo e(url('/')); ?>/img/loading.gif" alt="Search Loading">
                                </p>

                                <div class="ts-body-card"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
            <!-- search html end  -->
        </header>
        <!-- header end -->
<?php /**PATH /opt/bitnami/apache/htdocs/resources/views/header.blade.php ENDPATH**/ ?>