<?php

namespace App\Http\Controllers\Admin;

use App\Http\Requests\ListingRequest;
use Backpack\CRUD\app\Http\Controllers\CrudController;
use Backpack\CRUD\app\Library\CrudPanel\CrudPanelFacade as CRUD;

/**
 * Class ListingCrudController
 * @package App\Http\Controllers\Admin
 * @property-read \Backpack\CRUD\app\Library\CrudPanel\CrudPanel $crud
 */
class ListingCrudController extends CrudController
{
    use \Backpack\CRUD\app\Http\Controllers\Operations\ListOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\CreateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\UpdateOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\DeleteOperation;
    use \Backpack\CRUD\app\Http\Controllers\Operations\ShowOperation;

    /**
     * Configure the CrudPanel object. Apply settings to all operations.
     *
     * @return void
     */
    public function setup()
    {
        CRUD::setModel(\App\Models\Listing::class);
        CRUD::setRoute(config('backpack.base.route_prefix') . '/listing');
        CRUD::setEntityNameStrings('listing', 'listings');
    }

    /**
     * Define what happens when the List operation is loaded.
     *
     * @see  https://backpackforlaravel.com/docs/crud-operation-list-entries
     * @return void
     */
    protected function setupListOperation()
    {                           
        CRUD::column('first_name')->label('First name');
        CRUD::column('middle_name')->label('Middle name');
        CRUD::column('last_name')->label('Last name');
        CRUD::column('firm_id')->label('Firm')
        ->type('select')
        ->name('firm_id')
        ->entity('firm')
        ->attribute('name')
        ->model('App\Models\Firm');

        CRUD::column('type')->label('Type');

        CRUD::column([
            'name'  => 'view_link',
            'label' => 'View Front',
            'type'  => 'model_function',
            'function_name' => 'getfrontlink', 
            'limit' => 10000,
            'escaped' => false,
        ]);

    }

    /**
     * Define what happens when the Create operation is loaded.
     *
     * @see https://backpackforlaravel.com/docs/crud-operation-create
     * @return void
     */
    protected function setupCreateOperation()
    {
        CRUD::setValidation(ListingRequest::class);
        //CRUD::setFromDb(); // set fields from db columns.
        CRUD::field([  
         'tab' => 'Information',
         'name'  => 'featured',
         'type'  => 'switch',
         'label'    => 'Featured',
         'color'    => 'primary', 
         'onLabel' => '✓',
         'offLabel' => '✕',
         'wrapper' => [
            'class' => 'form-group col-md-6',
        ],
    ]);

        CRUD::field([ 
            'tab' => 'Information',
            'label'   => 'Indexing',
            'type'    => 'select_from_array',
            'name'    => 'url_index',
            'options' => ['yes' => 'Yes', 'no' => 'No'],
            'wrapper' => [
                'class' => 'form-group col-md-6',
            ],
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'prefix',
            'label' => 'Prefix',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'first_name',
            'label' => 'First name',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-3',
            ],
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'middle_name',
            'label' => 'Middle name',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'last_name',
            'label' => 'Last name',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-3',
            ],
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'suffix',
            'label' => 'Suffix',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ]);

        CRUD::field([
            'tab' => 'Biography',
            'name'  => 'description',
            'label' => 'Description',
            'type'  => 'wysiwyg',
            'wrapper' => [
                'class' => 'form-group col-md-12',
            ],
        ]);

        // base64_image
        CRUD::field([
            'tab' => 'Information',
            'label'        => "Profile picture",
            'name'         => "picture",
            'filename'     => null,
            'type'         => 'base64_image',
            'aspect_ratio' => 1, // set to 0 to allow any aspect ratio
            'crop'         => false, // set to true to allow cropping, false to disable
            'src'          => NULL, // null to read straight from DB, otherwise set to model accessor function
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name' => 'email',
            'label' => 'Email',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-6',
            ],
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'url',
            'label' => 'Website (url)',
            'type'  => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-6',
            ]
        ]);

        CRUD::field([
            'tab' => 'Information',
            'name'  => 'phone',
            'label' => 'Phone',
            'type'  => 'phone',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],


            'config' => [
                'onlyCountries' => ['us', 'pr'],
                'initialCountry' => 'us', // this needs to be in the allowed country list, either in `onlyCountries` or NOT in `excludeCountries`
                'separateDialCode' => true,
                'nationalMode' => true,
                'autoHideDialCode' => false,
                'placeholderNumberType' => 'PHONE',
            ]
        ]);
        CRUD::field([
            'tab' => 'Information',
            'name'  => 'fax',
            'label' => 'Fax',
            'type'  => 'phone',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],

            'config' => [
                'onlyCountries' => ['us', 'pr'],
                'initialCountry' => 'us', // this needs to be in the allowed country list, either in `onlyCountries` or NOT in `excludeCountries`
                'separateDialCode' => true,
                'nationalMode' => true,
                'autoHideDialCode' => false,
                'placeholderNumberType' => 'FAX',
            ]
        ]);

CRUD::field([   // Checklist
    'label'     => 'Language',
    'type'      => 'checklist',
    'name'      => 'language',
    'entity'    => 'language',
    'attribute' => 'name',
    'model'     => 'App\Models\Language',
    'pivot'     => true,
    'tab'       => 'Information'
    // 'number_of_columns' => 3,
]);


CRUD::field([   // CustomHTML
    'tab' => 'Information',
    'name'  => 'separator',
    'type'  => 'custom_html',
    'value' => '<hr>'
]);

//        CRUD::field('firm_id')->type('select2_from_ajax')->model('App\Models\Firm')->attribute('name')->entity('firm')->tab('Information');
CRUD::field([  
    'tab'	  => 'Information',
    'label'       => 'Firm', 
    'type'        => 'select2_from_ajax',
    'name'        => 'firm_id', 
    'entity'      => 'firm', 
    'attribute'   => 'name', 
    'data_source' => url('api/firm'), 

    // OPTIONAL
    // 'delay'                   => 500, // the minimum amount of time between ajax requests when searching in the field
    // 'placeholder'             => "Select a category", // placeholder for the select
    'minimum_input_length'    => 1, 
    'model'                   => "App\Models\Firm", 
    // 'dependencies'            => ['category'], // when a dependency changes, this select2 is reset to null
    'method'                  => 'POST',
    // 'include_all_form_fields' => false, // optional - only send the current field through AJAX (for a smaller payload if you're not using multiple chained select2s)
]);

//        CRUD::field('experience_years')->label('Years of experience')->type('number')->tab('Information');
CRUD::field('practiceAreas')->label('Practice Areas')->type('select2_multiple')
->entity('practiceAreas')
->attribute('name')
->model("App\Models\PracticeArea")
->pivot(true)
->tab('Information');

CRUD::field([
    'tab' => 'Information',
    'name'  => 'separator',
    'type'  => 'custom_html',
    'value' => '<hr>'
]);

//	CRUD::field('location')->type('address_google')->tab('Information');


/*
CRUD::field([   // Checklist
    'label'     => 'Fees',
    'type'      => 'checklist',
    'name'      => 'fees',
    'entity'    => 'fees',
    'attribute' => 'name',
    'model'     => 'App\Models\Fee',
    'pivot'     => true,
    'tab' 	=> 'Information'
    // 'number_of_columns' => 3,
]);
*/


CRUD::field([
    'tab'           => 'Addresses',
    'type'          => "relationship",
    'model'	    => 'App\Models\Address',
    'pivot'	    => true,
    'entity'	    => 'address',
    'name'	    => 'address',
    'subfields'   => [
        [
            'name' => 'label',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-12',
            ],
        ],
        [
         'name' => 'full_address',
         'type' => 'textarea',
         'wrapper' => [
            'class' => 'form-group col-md-12',
        ],
    ],
    [
        'name' => 'city',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'county',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'state',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'country',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-3',
        ],
    ],
    [
        'name' => 'zipcode',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'lat',
        'type' => 'hidden',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'lng',
        'type' => 'hidden',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'primary',
        'type' => 'switch',
        'label' => 'Will this be the primary address?',
        'color' => 'primary',
        'onLabel' => '✓',
        'offLabel' => '✕',
        'wrapper' => [
            'class' => 'form-group col-md-12',
        ],
    ],
],
]);

CRUD::field([
    'tab'           => 'Information',
    'type'          => "relationship",
    'model'         => 'App\Models\Fee',
    'label'	    => 'Fees',
    'pivot'         => true,
    'entity'        => 'fee',
    'name'          => 'fee',
    'wrapper'	=> [
     'class'	    => 'form-group col-md-4',
 ],
 'subfields'   => [
    [
        'name' => 'description',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-12',
        ],
    ],
],
]);

CRUD::field([
    'tab'           => 'Information',
    'label'	    => 'Jurisdictions Admitted to Practice',
    'type'          => "relationship",
    'model'         => 'App\Models\Jurisdiction',
    'pivot'         => true,
    'entity'        => 'jurisdiction',
    'name'          => 'jurisdiction',
    'wrapper'   => [
        'class'     => 'form-group col-md-8',
    ],
    'subfields'   => [
        [
            'name' => 'name',
            'label' => 'State name',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-10',
            ],
        ],
        [
            'name' => 'since',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
    ],
]);

CRUD::field([
    'tab'           => 'Professional Experiences',
    'label'         => 'Work history',
    'type'          => "relationship",
    'model'         => 'App\Models\ProfessionalExperience',
    'pivot'         => true,
    'entity'        => 'professional_experience',
    'name'          => 'professional_experience',
    'subfields'   => [
        [
            'name' => 'position',
            'label' => 'Position',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

        [
            'name' => 'employer',
            'label' => 'Employer',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],
        [
            'name' => 'year_started',
            'label' => 'Year (started)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'year_ended',
            'label' => 'Year (ended)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
    ],
]);

CRUD::field([
    'tab'           => 'Educational Experiences',
    'label'         => 'Institutions',
    'type'          => "relationship",
    'model'         => 'App\Models\Education',
    'pivot'         => true,
    'entity'        => 'education',
    'name'          => 'education',
    'subfields'   => [
        [
            'name' => 'institution',
            'label' => 'Institution',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

        [
            'name' => 'title',
            'label' => 'Title obtained',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],
        [
            'name' => 'year_started',
            'label' => 'Year (started)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'year_ended',
            'label' => 'Year (ended)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'activities',
            'label' => 'Activities',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],
        [
            'name' => 'honors',
            'label' => 'honors',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

    ],
]);

CRUD::field([
    'tab'           => 'Professional Associations',
    'label'         => 'Professional Associations',
    'type'          => "relationship",
    'model'         => 'App\Models\ProfessionalAssociation',
    'pivot'         => true,
    'entity'        => 'professional_association',
    'name'          => 'professional_association',
    'subfields'   => [
        [
            'name' => 'position',
            'label' => 'Position',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

        [
            'name' => 'institution',
            'label' => 'Institution',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],
        [
            'name' => 'year_started',
            'label' => 'Year (started)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'year_ended',
            'label' => 'Year (ended)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
    ],
]);

CRUD::field([
    'tab'           => 'Publications',
    'label'         => 'Publications',
    'type'          => "relationship",
    'model'         => 'App\Models\Publication',
    'pivot'         => true,
    'entity'        => 'publication',
    'name'          => 'publication',
    'subfields'   => [
        [
            'name' => 'title',
            'label' => 'Title',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

        [
            'name' => 'url',
            'label' => 'Link (url)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],
        [
            'name' => 'medium',
            'label' => 'Medium (newspaper, book or magazine)',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'date_published',
            'label' => 'Date published',
            'type' => 'date',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
    ],
]);

CRUD::field([
    'tab'           => 'Awards',
    'label'         => 'Awards',
    'type'          => "relationship",
    'model'         => 'App\Models\Award',
    'pivot'         => true,
    'entity'        => 'award',
    'name'          => 'award',
    'subfields'   => [
        [
            'name' => 'name',
            'label' => 'Title',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

        [
            'name' => 'organization',
            'label' => 'Entity / Organization',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-3',
            ],
        ],
        [
            'name' => 'year',
            'label' => 'Year',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'note',
            'label' => 'Note',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-3',
            ],
        ],

    ],
]);

CRUD::field([
    'tab'           => 'Engagements',
    'label'         => 'Engagements',
    'type'          => "relationship",
    'model'         => 'App\Models\Engagement',
    'pivot'         => true,
    'entity'        => 'engagement',
    'name'          => 'engagement',
    'subfields'   => [
        [
            'name' => 'name',
            'label' => 'Name',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-4',
            ],
        ],

        [
            'name' => 'location',
            'label' => 'Location',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-3',
            ],
        ],
        [
            'name' => 'date',
            'label' => 'Date',
            'type' => 'date',
            'wrapper' => [
                'class' => 'form-group col-md-2',
            ],
        ],
        [
            'name' => 'note',
            'label' => 'Note',
            'type' => 'text',
            'wrapper' => [
                'class' => 'form-group col-md-3',
            ],
        ],

    ],
]);

CRUD::field([
    'tab'           => 'Links',
    'label'         => 'Website & Blog Entries',
    'type'          => "relationship",
    'model'         => 'App\Models\Link',
    'pivot'         => true,
    'entity'        => 'link',
    'name'          => 'link',
    'subfields'   => [
        [
            'name' => 'type',
            'label' => 'Type',
            'type' => 'enum',
            'options' => [
             'website' => 'Website',
             'blog' => 'Blog'
         ],
         'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'title',
        'label' => 'Title',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-6',
        ],
    ],

    [
        'name' => 'url',
        'label' => 'Link (url)',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
    [
        'name' => 'date_published',
        'label' => 'Date published',
        'type' => 'date',
        'wrapper' => [
            'class' => 'form-group col-md-2',
        ],
    ],
],
]);

CRUD::field([
    'tab'           => 'Social Networks',
    'label'         => 'Social Networks',
    'type'          => "relationship",
    'model'         => 'App\Models\SocialNetwork',
    'pivot'         => true,
    'entity'        => 'social_network',
    'name'          => 'social_network',
    'subfields'   => [
        [
            'name' => 'type',
            'label' => 'Type',
            'type' => 'enum',
            'options' => [
              'linkedin' => 'LinkedIn',
              'facebook' => 'FaceBook',
              'twitter' => 'Twitter',
              'justia' => 'Justia',
              'instagram' => 'Instagram'
          ],
          'wrapper' => [
            'class' => 'form-group col-md-4',
        ],
    ],
    [
        'name' => 'url',
        'label' => 'Link (url)',
        'type' => 'text',
        'wrapper' => [
            'class' => 'form-group col-md-6',
        ],
    ],
],
]);

CRUD::field('user_id')->label('Listing owner')->type('select')->model('App\Models\User')->attribute('name')->entity('user')->tab('Account');


        /**
         * Fields can be defined using the fluent syntax:
         * - CRUD::field('price')->type('number');
         */
    }

    /**
     * Define what happens when the Update operation is loaded.
     *
     * @see https://backpackforlaravel.com/docs/crud-operation-update
     * @return void
     */
    protected function setupUpdateOperation()
    {
        $this->setupCreateOperation();
    }
    protected function setupShowOperation()
    {
        //$this->setupListOperation();
        //$this->autoSetupShowOperation();
        CRUD::column([
            'tab' => 'Information',
            'name'  => 'prefix',
            'label' => 'Prefix',
        ]);

        CRUD::column([
            'name'  => 'first_name',
            'label' => 'First name',
        ]);

        CRUD::column([
            'name'  => 'middle_name',
            'label' => 'Middle name',
        ]);

        CRUD::column([
            'name'  => 'last_name',
            'label' => 'Last name',
        ]);

        CRUD::column([
            'name'  => 'suffix',
            'label' => 'Suffix',
        ]);
        CRUD::column([
            'name'  => 'phone',
            'label' => 'Phone',
        ]);

        CRUD::column([
            'name'  => 'fax',
            'label' => 'Fax',
        ]);

        CRUD::column([
            'name'  => 'url',
            'label' => 'Website (url)',
        ]);

        CRUD::column([
            'name'  => 'email',
            'label' => 'Email',
        ]);

        CRUD::column('firm_id')->label('Firm')
        ->name('firm_id') // the name of the relationship's method in the model (and the column in the db)
        ->entity('firm')  // the method that defines the relationship in your Model
        ->attribute('name') // the column in the related model that you want to show
        ->model('App\Models\Firm'); // the related model

        CRUD::column('practiceAreas')->label('Practice areas')
        ->entity('practiceAreas')
        ->attribute('name')
        ->model("App\Models\PracticeArea")
        ->pivot(true);

/*
        CRUD::column([
            'name'  => 'experience_years',
            'label' => 'Years of experience',
        ]);
*/

        CRUD::column([
            'type'          => "relationship",
            'model'	    => 'App\Models\Fee',
            'pivot'	    => true,
            'entity'	    => 'fee',
            'name'	    => 'fee',
            'label'     => 'Fees',
        ]);

        CRUD::column([
            'type'          => "relationship",
            'model'	    => 'App\Models\Address',
            'pivot'	    => true,
            'entity'	    => 'address',
            'name'	    => 'address',
            'label'     => 'Addresses',
        ]);

        CRUD::column([
            'label'         => 'Work history',
            'type'          => "relationship",
            'model'         => 'App\Models\ProfessionalExperience',
            'pivot'         => true,
            'entity'        => 'professional_experience',
            'name'          => 'professional_experience',
        ]);

        CRUD::column([
            'label'         => 'Educational experience',
            'type'          => "relationship",
            'model'         => 'App\Models\Education',
            'pivot'         => true,
            'entity'        => 'education',
            'name'          => 'education',
            'attribute'     => 'title',
        ]);

        CRUD::column([
            'label'         => 'Professional associations',
            'type'          => "relationship",
            'model'         => 'App\Models\ProfessionalAssociation',
            'pivot'         => true,
            'entity'        => 'professional_association',
            'name'          => 'professional_association',
            'attribute'     => 'title',
        ]);

        CRUD::column([
            'label'         => 'Publications',
            'type'          => "relationship",
            'model'         => 'App\Models\Publication',
            'pivot'         => true,
            'entity'        => 'publication',
            'name'          => 'publication',
            'attribute'     => 'title',
        ]);

        CRUD::column([
            'label'         => 'Links',
            'type'          => "relationship",
            'model'         => 'App\Models\Link',
            'pivot'         => true,
            'entity'        => 'link',
            'name'          => 'link',
            'attribute'     => 'title',
        ]);

        CRUD::column([
            'label'         => 'Social networks',
            'type'          => "relationship",
            'model'         => 'App\Models\SocialNetwork',
            'pivot'         => true,
            'entity'        => 'social_network',
            'name'          => 'social_network',
            'attribute'     => 'type',
        ]);
    }
}
